% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pals.R
\name{palette.display}
\alias{palette.display}
\title{Built-in Paletteknife Palettes}
\usage{
palette.display(palette = palette.colorbrewer)
}
\arguments{
\item{palette}{Character vector of palette names or a named list of colour vectors}
}
\value{
No return value (\code{NULL})
}
\description{
Plot a list of palettes for comparison
}
\examples{
palette.display(c(palette.misc,palette.colorbrewer,palette.viridis))

palette.display(c(list(rainbow=rainbow(10), default=palette()),
               palette.misc, palette.colorbrewer[c('Paired','Set1','Set2')] ))

palette.display(list(rainbow=rainbow(45)[30:1], turbo=palette.viridis$turbo ))

# Call by vector of names - here it gets 'Paired' from palette.colorbrewer
palette.display(palette.pals() )

# Bit of fun ordering a list of palettes (MUST be same palette size)
mat_cols = do.call(rbind, lapply(palette.colorbrewer[9:26],
                          function(hex) as.vector(rgb2hsv(col2rgb(hex)))))
palette.display(palette.colorbrewer[9:26][hclust(dist(mat_cols))$order])

}
