% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.r
\name{confint.palm}
\alias{confint.palm}
\title{Extracts Neyman-Scott point process parameter confidence intervals.}
\usage{
\method{confint}{palm}(object, parm = NULL, level = 0.95, method = "percentile", ...)
}
\arguments{
\item{object}{A fitted model returned by \link{fit.ns},
bootstrapped using \link[boot]{boot}.}

\item{parm}{A vector of parameter names, specifying which
parameters are to be given confidence intervals. Defaults to
all parameters.}

\item{level}{The confidence level required.}

\item{method}{A character string specifying the method used to
calculate confidence intervals. Choices are "normal", for a
normal approximation, and "percentile", for the percentile
method.}

\item{...}{Other parameters (for S3 generic compatibility).}
}
\description{
Extracts confidence intervals for estimated and derived parameters
from a model fitted using \link{fit.ns}, \link{fit.void}, or
\link{fit.twocamera}, then bootstrapped using \link{boot.palm}.
}
\details{
Bootstrap parameter estimates can be found in the \code{boots}
component of the model object, so alternative confidence interval
methods can be calculated by hand.
}
\examples{
## Fitting model.
fit <- fit.ns(example.2D, lims = rbind(c(0, 1), c(0, 1)), R = 0.5)
## Carrying out bootstrap.
fit <- boot.palm(fit, N = 100)
## Calculating 95\% confidence intervals.
confint(fit)
## Estimates are very imprecise---these data were only used as
## they can be fitted and bootstrapped quickly for example purposes.

}
