% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructors_elements.R
\name{get_element}
\alias{get_element}
\title{wrapper around getElementText() method to generate safe scraping code}
\usage{
get_element(using, value, name = NULL, multiple = FALSE, prev = NULL)
}
\arguments{
\item{using}{character string specifying locator scheme to use to search elements. Available schemes: "class name", "css selector", "id", "name", "link text", "partial link text", "tag name", "xpath".}

\item{value}{character string specifying the search target.}

\item{name}{character string specifying the object name the RSelenium "wElement" class object should be saved to. If NULL a name will be generated automatically.}

\item{multiple}{logical indicating whether multiple elements should be returned. If TRUE the findElements() method will be invoked.}

\item{prev}{a placeholder for the output of functions being piped into get_element(). Defaults to NULL and should not be altered.}
}
\value{
a character string defining 'RSelenium' getElementText() instructions that can be pasted into a scraping function.
}
\description{
wrapper around getElementText() method to generate safe scraping code
}
\examples{
\dontrun{

#navigate to wikipedia, type "Hello" into the search box,
#press enter, get page header

parsel::go("https://www.wikipedia.org/") \%>>\%
parsel::type(using = "id",
             value = "'searchInput'",
             name = "searchbox",
             text = c("Hello","\uE007")) \%>>\%
parsel::get_element(using = "id",
                    value = "'firstHeading'",
                    name = "header") \%>>\%
            show()

#navigate to wikipedia, type "Hello" into the search box, press enter,
#get page header, save in external data.frame x.

parsel::go("https://www.wikipedia.org/") \%>>\%
parsel::type(using = "id",
             value = "'searchInput'",
             name = "searchbox",
             text = c("Hello","\uE007")) \%>>\%
parsel::get_element(using = "id",
                    value = "'firstHeading'",
                    name = "x[,1]") \%>>\%
                    show()

}
}
