% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{wallaceII}
\alias{wallaceII}
\alias{wallaceII,Partition,Partition-method}
\alias{wallaceII,PairCoefficients,missing-method}
\title{Wallace II}
\usage{
wallaceII(p, q)

\S4method{wallaceII}{Partition,Partition}(p, q)

\S4method{wallaceII}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute Wallace' index II
\deqn{\frac{N_{11}}{N_{12}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{wallaceII(p = Partition, q = Partition)}: Compute given two partitions

\item \code{wallaceII(p = PairCoefficients, q = missing)}: Compute given the pair coefficients

}}
\examples{
isTRUE(all.equal(wallaceII(new("Partition", c(0, 0, 0, 1, 1)), 
                           new("Partition", c(0, 0, 1, 1, 1))), 0.5))

}
\references{
\insertRef{Wallace1983}{partitionComparison}
}
\seealso{
\code{\link{folwkesMallowsIndex}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
