% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_partial_time_uncert_resolvers.R
\name{possibly.partial_time_logical}
\alias{possibly.partial_time_logical}
\title{Determine whether a partial_time logical matrix is possibly TRUE}
\usage{
\method{possibly}{partial_time_logical}(x, by = ncol(attr(x, "pttm_lgl")), ...)
}
\arguments{
\item{x}{a partial_time_logical matrix for coersion}

\item{by}{the resolution of assessment, a column or index}

\item{...}{additional arguments unused}
}
\value{
A logical vector indicating whether the partial time comparison is
possibly or definitely true provided any uncertainty represented in the
\code{partial_time} inputs.
}
\description{
Determine whether a partial_time logical matrix is possibly TRUE
}
\examples{

x <- as.parttime(c("",     "2019-02",    "2019-01-02"))
y <- as.parttime(c("2018", "2019-02-01", "2018"))

possibly(x != y)
possibly(x != y, by = "month")

}
