% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{Simulate}
\alias{Simulate}
\title{Simulate}
\usage{
Simulate(tickers, run_count = 10)
}
\arguments{
\item{tickers}{A character vector of instrument tickers.}

\item{run_count}{Defaults to 10 runs. An integer defining the number of
simulated market data universes.}
}
\value{
Returns a list of multiple time series' of dollar movements across
the strategies for the tickers provided.
}
\description{
Computes the dollar returns of a 100,000 USD portfolio
according to the weights computed by \link[pathlit]{get_weights}, but across
simulated (normally-distributed) market data.
See \url{https://www.pathlit.io/docs/api/sims/} for more information.
}
\examples{
\dontrun{
Simulate(c("AAPL", "HOG", "KO"), 5)
}
}
\author{
Riasat Ali Istiaque, \email{riasat.istiaque@pathlit.io}
}
