% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrockagent_operations.R
\name{bedrockagent_create_knowledge_base}
\alias{bedrockagent_create_knowledge_base}
\title{Creates a knowledge base}
\usage{
bedrockagent_create_knowledge_base(
  clientToken = NULL,
  description = NULL,
  knowledgeBaseConfiguration,
  name,
  roleArn,
  storageConfiguration = NULL,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}

\item{description}{A description of the knowledge base.}

\item{knowledgeBaseConfiguration}{[required] Contains details about the embeddings model used for the knowledge base.}

\item{name}{[required] A name for the knowledge base.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role with permissions to
invoke API operations on the knowledge base.}

\item{storageConfiguration}{Contains details about the configuration of the vector database used for
the knowledge base.}

\item{tags}{Specify the key-value pairs for the tags that you want to attach to your
knowledge base in this object.}
}
\description{
Creates a knowledge base. A knowledge base contains your data sources so that Large Language Models (LLMs) can use your data. To create a knowledge base, you must first set up your data sources and configure a supported vector store. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/}{Set up a knowledge base}.

See \url{https://www.paws-r-sdk.com/docs/bedrockagent_create_knowledge_base/} for full documentation.
}
\keyword{internal}
