% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_inference_components}
\alias{sagemaker_list_inference_components}
\title{Lists the inference components in your account and their properties}
\usage{
sagemaker_list_inference_components(
  SortBy = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  NameContains = NULL,
  CreationTimeBefore = NULL,
  CreationTimeAfter = NULL,
  LastModifiedTimeBefore = NULL,
  LastModifiedTimeAfter = NULL,
  StatusEquals = NULL,
  EndpointNameEquals = NULL,
  VariantNameEquals = NULL
)
}
\arguments{
\item{SortBy}{The field by which to sort the inference components in the response. The
default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Descending}.}

\item{NextToken}{A token that you use to get the next set of results following a
truncated response. If the response to the previous request was
truncated, that response provides the value for this token.}

\item{MaxResults}{The maximum number of inference components to return in the response.
This value defaults to 10.}

\item{NameContains}{Filters the results to only those inference components with a name that
contains the specified string.}

\item{CreationTimeBefore}{Filters the results to only those inference components that were created
before the specified time.}

\item{CreationTimeAfter}{Filters the results to only those inference components that were created
after the specified time.}

\item{LastModifiedTimeBefore}{Filters the results to only those inference components that were updated
before the specified time.}

\item{LastModifiedTimeAfter}{Filters the results to only those inference components that were updated
after the specified time.}

\item{StatusEquals}{Filters the results to only those inference components with the
specified status.}

\item{EndpointNameEquals}{An endpoint name to filter the listed inference components. The response
includes only those inference components that are hosted at the
specified endpoint.}

\item{VariantNameEquals}{A production variant name to filter the listed inference components. The
response includes only those inference components that are hosted at the
specified variant.}
}
\description{
Lists the inference components in your account and their properties.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_list_inference_components/} for full documentation.
}
\keyword{internal}
