% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_image_version}
\alias{sagemaker_update_image_version}
\title{Updates the properties of a SageMaker AI image version}
\usage{
sagemaker_update_image_version(
  ImageName,
  Alias = NULL,
  Version = NULL,
  AliasesToAdd = NULL,
  AliasesToDelete = NULL,
  VendorGuidance = NULL,
  JobType = NULL,
  MLFramework = NULL,
  ProgrammingLang = NULL,
  Processor = NULL,
  Horovod = NULL,
  ReleaseNotes = NULL
)
}
\arguments{
\item{ImageName}{[required] The name of the image.}

\item{Alias}{The alias of the image version.}

\item{Version}{The version of the image.}

\item{AliasesToAdd}{A list of aliases to add.}

\item{AliasesToDelete}{A list of aliases to delete.}

\item{VendorGuidance}{The availability of the image version specified by the maintainer.
\itemize{
\item \code{NOT_PROVIDED}: The maintainers did not provide a status for image
version stability.
\item \code{STABLE}: The image version is stable.
\item \code{TO_BE_ARCHIVED}: The image version is set to be archived. Custom
image versions that are set to be archived are automatically
archived after three months.
\item \code{ARCHIVED}: The image version is archived. Archived image versions
are not searchable and are no longer actively supported.
}}

\item{JobType}{Indicates SageMaker AI job type compatibility.
\itemize{
\item \code{TRAINING}: The image version is compatible with SageMaker AI
training jobs.
\item \code{INFERENCE}: The image version is compatible with SageMaker AI
inference jobs.
\item \code{NOTEBOOK_KERNEL}: The image version is compatible with SageMaker AI
notebook kernels.
}}

\item{MLFramework}{The machine learning framework vended in the image version.}

\item{ProgrammingLang}{The supported programming language and its version.}

\item{Processor}{Indicates CPU or GPU compatibility.
\itemize{
\item \code{CPU}: The image version is compatible with CPU.
\item \code{GPU}: The image version is compatible with GPU.
}}

\item{Horovod}{Indicates Horovod compatibility.}

\item{ReleaseNotes}{The maintainer description of the image version.}
}
\description{
Updates the properties of a SageMaker AI image version.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_image_version/} for full documentation.
}
\keyword{internal}
