% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_notebook_instance}
\alias{sagemaker_update_notebook_instance}
\title{Updates a notebook instance}
\usage{
sagemaker_update_notebook_instance(
  NotebookInstanceName,
  InstanceType = NULL,
  RoleArn = NULL,
  LifecycleConfigName = NULL,
  DisassociateLifecycleConfig = NULL,
  VolumeSizeInGB = NULL,
  DefaultCodeRepository = NULL,
  AdditionalCodeRepositories = NULL,
  AcceleratorTypes = NULL,
  DisassociateAcceleratorTypes = NULL,
  DisassociateDefaultCodeRepository = NULL,
  DisassociateAdditionalCodeRepositories = NULL,
  RootAccess = NULL,
  InstanceMetadataServiceConfiguration = NULL
)
}
\arguments{
\item{NotebookInstanceName}{[required] The name of the notebook instance to update.}

\item{InstanceType}{The Amazon ML compute instance type.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM role that SageMaker AI can
assume to access the notebook instance. For more information, see
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{SageMaker AI Roles}.

To be able to pass this role to SageMaker AI, the caller of this API
must have the \code{iam:PassRole} permission.}

\item{LifecycleConfigName}{The name of a lifecycle configuration to associate with the notebook
instance. For information about lifestyle configurations, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/notebook-lifecycle-config.html}{Step 2.1: (Optional) Customize a Notebook Instance}.}

\item{DisassociateLifecycleConfig}{Set to \code{true} to remove the notebook instance lifecycle configuration
currently associated with the notebook instance. This operation is
idempotent. If you specify a lifecycle configuration that is not
associated with the notebook instance when you call this method, it does
not throw an error.}

\item{VolumeSizeInGB}{The size, in GB, of the ML storage volume to attach to the notebook
instance. The default value is 5 GB. ML storage volumes are encrypted,
so SageMaker AI can't determine the amount of available free space on
the volume. Because of this, you can increase the volume size when you
update a notebook instance, but you can't decrease the volume size. If
you want to decrease the size of the ML storage volume in use, create a
new notebook instance with the desired size.}

\item{DefaultCodeRepository}{The Git repository to associate with the notebook instance as its
default code repository. This can be either the name of a Git repository
stored as a resource in your account, or the URL of a Git repository in
\href{https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html}{Amazon Web Services CodeCommit}
or in any other Git repository. When you open a notebook instance, it
opens in the directory that contains this repository. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html}{Associating Git Repositories with SageMaker AI Notebook Instances}.}

\item{AdditionalCodeRepositories}{An array of up to three Git repositories to associate with the notebook
instance. These can be either the names of Git repositories stored as
resources in your account, or the URL of Git repositories in \href{https://docs.aws.amazon.com/codecommit/latest/userguide/welcome.html}{Amazon Web Services CodeCommit}
or in any other Git repository. These repositories are cloned at the
same level as the default repository of your notebook instance. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/nbi-git-repo.html}{Associating Git Repositories with SageMaker AI Notebook Instances}.}

\item{AcceleratorTypes}{This parameter is no longer supported. Elastic Inference (EI) is no
longer available.

This parameter was used to specify a list of the EI instance types to
associate with this notebook instance.}

\item{DisassociateAcceleratorTypes}{This parameter is no longer supported. Elastic Inference (EI) is no
longer available.

This parameter was used to specify a list of the EI instance types to
remove from this notebook instance.}

\item{DisassociateDefaultCodeRepository}{The name or URL of the default Git repository to remove from this
notebook instance. This operation is idempotent. If you specify a Git
repository that is not associated with the notebook instance when you
call this method, it does not throw an error.}

\item{DisassociateAdditionalCodeRepositories}{A list of names or URLs of the default Git repositories to remove from
this notebook instance. This operation is idempotent. If you specify a
Git repository that is not associated with the notebook instance when
you call this method, it does not throw an error.}

\item{RootAccess}{Whether root access is enabled or disabled for users of the notebook
instance. The default value is \code{Enabled}.

If you set this to \code{Disabled}, users don't have root access on the
notebook instance, but lifecycle configuration scripts still run with
root permissions.}

\item{InstanceMetadataServiceConfiguration}{Information on the IMDS configuration of the notebook instance}
}
\description{
Updates a notebook instance. NotebookInstance updates include upgrading or downgrading the ML compute instance used for your notebook instance to accommodate changes in your workload requirements.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_notebook_instance/} for full documentation.
}
\keyword{internal}
