% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_update_resiliency_policy}
\alias{resiliencehub_update_resiliency_policy}
\title{Updates a resiliency policy}
\usage{
resiliencehub_update_resiliency_policy(
  dataLocationConstraint = NULL,
  policy = NULL,
  policyArn,
  policyDescription = NULL,
  policyName = NULL,
  tier = NULL
)
}
\arguments{
\item{dataLocationConstraint}{Specifies a high-level geographical location constraint for where your
resilience policy data can be stored.}

\item{policy}{Resiliency policy to be created, including the recovery time objective
(RTO) and recovery point objective (RPO) in seconds.}

\item{policyArn}{[required] Amazon Resource Name (ARN) of the resiliency policy. The format for this
ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:resiliency-policy/\code{policy-id}.
For more information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{Amazon Web Services General Reference} guide.}

\item{policyDescription}{Description of the resiliency policy.}

\item{policyName}{Name of the resiliency policy.}

\item{tier}{The tier for this resiliency policy, ranging from the highest severity
(\code{MissionCritical}) to lowest (\code{NonCritical}).}
}
\description{
Updates a resiliency policy.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_update_resiliency_policy/} for full documentation.
}
\keyword{internal}
