% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_send_command}
\alias{ssm_send_command}
\title{Runs commands on one or more managed nodes}
\usage{
ssm_send_command(
  InstanceIds = NULL,
  Targets = NULL,
  DocumentName,
  DocumentVersion = NULL,
  DocumentHash = NULL,
  DocumentHashType = NULL,
  TimeoutSeconds = NULL,
  Comment = NULL,
  Parameters = NULL,
  OutputS3Region = NULL,
  OutputS3BucketName = NULL,
  OutputS3KeyPrefix = NULL,
  MaxConcurrency = NULL,
  MaxErrors = NULL,
  ServiceRoleArn = NULL,
  NotificationConfig = NULL,
  CloudWatchOutputConfig = NULL,
  AlarmConfiguration = NULL
)
}
\arguments{
\item{InstanceIds}{The IDs of the managed nodes where the command should run. Specifying
managed node IDs is most useful when you are targeting a limited number
of managed nodes, though you can specify up to 50 IDs.

To target a larger number of managed nodes, or if you prefer not to list
individual node IDs, we recommend using the \code{Targets} option instead.
Using \code{Targets}, which accepts tag key-value pairs to identify the
managed nodes to send commands to, you can a send command to tens,
hundreds, or thousands of nodes at once.

For more information about how to use targets, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html}{Run commands at scale}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{Targets}{An array of search criteria that targets managed nodes using a
\verb{Key,Value} combination that you specify. Specifying targets is most
useful when you want to send a command to a large number of managed
nodes at once. Using \code{Targets}, which accepts tag key-value pairs to
identify managed nodes, you can send a command to tens, hundreds, or
thousands of nodes at once.

To send a command to a smaller number of managed nodes, you can use the
\code{InstanceIds} option instead.

For more information about how to use targets, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html}{Run commands at scale}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{DocumentName}{[required] The name of the Amazon Web Services Systems Manager document (SSM
document) to run. This can be a public document or a custom document. To
run a shared document belonging to another account, specify the document
Amazon Resource Name (ARN). For more information about how to use shared
documents, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/documents-ssm-sharing.html}{Sharing SSM documents}
in the \emph{Amazon Web Services Systems Manager User Guide}.

If you specify a document name or ARN that hasn't been shared with your
account, you receive an \code{InvalidDocument} error.}

\item{DocumentVersion}{The SSM document version to use in the request. You can specify
$DEFAULT, $LATEST, or a specific version number. If you run commands by
using the Command Line Interface (Amazon Web Services CLI), then you
must escape the first two options by using a backslash. If you specify a
version number, then you don't need to use the backslash. For example:

--document-version "$DEFAULT"

--document-version "$LATEST"

--document-version "3"}

\item{DocumentHash}{The Sha256 or Sha1 hash created by the system when the document was
created.

Sha1 hashes have been deprecated.}

\item{DocumentHashType}{Sha256 or Sha1.

Sha1 hashes have been deprecated.}

\item{TimeoutSeconds}{If this time is reached and the command hasn't already started running,
it won't run.}

\item{Comment}{User-specified information about the command, such as a brief
description of what the command should do.}

\item{Parameters}{The required and optional parameters specified in the document being
run.}

\item{OutputS3Region}{(Deprecated) You can no longer specify this parameter. The system
ignores it. Instead, Systems Manager automatically determines the Amazon
Web Services Region of the S3 bucket.}

\item{OutputS3BucketName}{The name of the S3 bucket where command execution responses should be
stored.}

\item{OutputS3KeyPrefix}{The directory structure within the S3 bucket where the responses should
be stored.}

\item{MaxConcurrency}{(Optional) The maximum number of managed nodes that are allowed to run
the command at the same time. You can specify a number such as 10 or a
percentage such as 10\%. The default value is \code{50}. For more information
about how to use \code{MaxConcurrency}, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity}{Using concurrency controls}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{MaxErrors}{The maximum number of errors allowed without the command failing. When
the command fails one more time beyond the value of \code{MaxErrors}, the
systems stops sending the command to additional targets. You can specify
a number like 10 or a percentage like 10\%. The default value is \code{0}. For
more information about how to use \code{MaxErrors}, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors}{Using error controls}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{ServiceRoleArn}{The ARN of the Identity and Access Management (IAM) service role to use
to publish Amazon Simple Notification Service (Amazon SNS) notifications
for Run Command commands.

This role must provide the \code{sns:Publish} permission for your
notification topic. For information about creating and using this
service role, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/monitoring-sns-notifications.html}{Monitoring Systems Manager status changes using Amazon SNS notifications}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{NotificationConfig}{Configurations for sending notifications.}

\item{CloudWatchOutputConfig}{Enables Amazon Web Services Systems Manager to send Run Command output
to Amazon CloudWatch Logs. Run Command is a tool in Amazon Web Services
Systems Manager.}

\item{AlarmConfiguration}{The CloudWatch alarm you want to apply to your command.}
}
\description{
Runs commands on one or more managed nodes.

See \url{https://www.paws-r-sdk.com/docs/ssm_send_command/} for full documentation.
}
\keyword{internal}
