% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_managed_login_branding}
\alias{cognitoidentityprovider_create_managed_login_branding}
\title{Creates a new set of branding settings for a user pool style and
associates it with an app client}
\usage{
cognitoidentityprovider_create_managed_login_branding(
  UserPoolId,
  ClientId,
  UseCognitoProvidedValues = NULL,
  Settings = NULL,
  Assets = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool where you want to create a new branding style.}

\item{ClientId}{[required] The app client that you want to create the branding style for. Each
style is permanently linked to an app client. To change the style for an
app client, delete the existing style with
\code{\link[=cognitoidentityprovider_delete_managed_login_branding]{delete_managed_login_branding}}
and create a new one.}

\item{UseCognitoProvidedValues}{When true, applies the default branding style options. These default
options are managed by Amazon Cognito. You can modify them later in the
branding designer.

When you specify \code{true} for this option, you must also omit values for
\code{Settings} and \code{Assets} in the request.}

\item{Settings}{A JSON file, encoded as a \code{Document} type, with the the settings that
you want to apply to your style.}

\item{Assets}{An array of image files that you want to apply to roles like
backgrounds, logos, and icons. Each object must also indicate whether it
is for dark mode, light mode, or browser-adaptive mode.}
}
\description{
Creates a new set of branding settings for a user pool style and associates it with an app client. This operation is the programmatic option for the creation of a new style in the branding designer.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_managed_login_branding/} for full documentation.
}
\keyword{internal}
