% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3tables_operations.R
\name{s3tables_create_table}
\alias{s3tables_create_table}
\title{Creates a new table associated with the given namespace in a table
bucket}
\usage{
s3tables_create_table(tableBucketARN, namespace, name, format, metadata = NULL)
}
\arguments{
\item{tableBucketARN}{[required] The Amazon Resource Name (ARN) of the table bucket to create the table
in.}

\item{namespace}{[required] The namespace to associated with the table.}

\item{name}{[required] The name for the table.}

\item{format}{[required] The format for the table.}

\item{metadata}{The metadata for the table.}
}
\description{
Creates a new table associated with the given namespace in a table bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-tables-create.html}{Creating an Amazon S3 table} in the \emph{Amazon Simple Storage Service User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3tables_create_table/} for full documentation.
}
\keyword{internal}
