% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{as.basic.tri}
\alias{as.basic.tri}
\title{The labels of the vertices of a triangle in the basic triangle form}
\usage{
as.basic.tri(tri, scaled = FALSE)
}
\arguments{
\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{scaled}{A logical argument
for scaling the resulting basic triangle.
If \code{scaled=TRUE}, then the resulting triangle is
scaled to be a regular basic triangle, i.e.,
longest edge having unit length,
else the new triangle \eqn{T(A,B,C)} is nonscaled.
The default is \code{scaled=FALSE}.}
}
\value{
A \code{list} with three elements
\item{tri}{The vertices of the basic triangle stacked row-wise
and labeled row-wise as \eqn{A}, \eqn{B}, \eqn{C}.}
\item{desc}{Description of the edges based on the vertices, i.e.,
 \code{"Edges (in decreasing length are) AB, BC, and AC"}.}
\item{orig.order}{Row order of the input triangle, \code{tri},
when converted to the scaled version of the basic triangle}
}
\description{
Labels the vertices of triangle, \code{tri},
as \eqn{ABC} so that \eqn{AB} is the longest edge,
\eqn{BC} is the second longest
and \eqn{AC} is the shortest edge
(the order is as in the basic triangle).

The standard basic triangle form is \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
where \eqn{c_1} is in \eqn{[0,1/2]},
\eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.
Any given triangle can be mapped to the standard basic triangle
by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling,
preserving uniformity of the points in the
original triangle. Hence, standard basic triangle is useful for simulation
studies under the uniformity hypothesis.

The option \code{scaled} a logical argument
for scaling the resulting triangle or not.
If \code{scaled=TRUE}, then the resulting triangle is scaled
to be a regular basic triangle,
i.e., longest edge having unit length,
else (i.e., if \code{scaled=FALSE} which is the default),
the new triangle \eqn{T(A,B,C)} is nonscaled,
i.e., the longest edge \eqn{AB} may not be of unit length.
The vertices of the resulting triangle (whether scaled or not) is presented
in the order of vertices of the corresponding
basic triangle, however when scaled the triangle
is equivalent to the basic triangle \eqn{T_b} up to translation and rotation.
That is, this function converts any triangle to a basic triangle
(up to translation and rotation),
so that the output triangle is $T(A',B',C')$
so that edges in decreasing length are $A'B'$, $B'C'$, and $A'C'$.
Most of the times,
the resulting triangle will still need to be translated
and/or rotated to be in the standard basic triangle form.
}
\examples{
\donttest{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);

as.basic.tri(rbind(A,B,C))
as.basic.tri(rbind(B,C,A))

A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
as.basic.tri(rbind(A,B,C))
as.basic.tri(rbind(A,C,B))
as.basic.tri(rbind(B,A,C))
}

}
\author{
Elvan Ceyhan
}
