% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{roysPval}
\alias{roysPval}
\alias{roysPval.default}
\alias{roysPval.PcevClassical}
\alias{roysPval.PcevSingular}
\alias{roysPval.PcevBlock}
\title{Roy's largest root exact test}
\usage{
roysPval(pcevObj, ...)

\method{roysPval}{default}(pcevObj, ...)

\method{roysPval}{PcevClassical}(pcevObj, shrink, index, ...)

\method{roysPval}{PcevSingular}(pcevObj, shrink, index, nperm, ...)

\method{roysPval}{PcevBlock}(pcevObj, shrink, index, ...)
}
\arguments{
\item{pcevObj}{A pcev object of class \code{PcevClassical} or 
\code{PcevBlock}}

\item{...}{Extra parameters.}

\item{shrink}{Should we use a shrinkage estimate of the residual variance?}

\item{index}{If \code{pcevObj} is of class \code{PcevBlock}, \code{index} is
a vector describing the block to which individual response variables 
correspond}

\item{nperm}{Number of permutations for Tracy-Widom empirical estimate.}
}
\description{
In the classical domain of PCEV applicability this function uses Johnstone's
approximation to the null distribution of ' Roy's Largest Root statistic.
It uses a location-scale variant of the Tracy-Widom distribution of order 1.
}
\details{
Note that if \code{shrink} is set to \code{TRUE}, the location-scale 
parameters are estimated using a small number of permutations.
}
