% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_lod.R
\name{sim_lod}
\alias{sim_lod}
\title{Simulate limit of detection data}
\usage{
sim_lod(D, q)
}
\arguments{
\item{D}{The input data matrix.}

\item{q}{A double in the range \verb{[0, 1]} specifying the quantile to use
in creating the column-wise LODs. Passed as the \code{probs} argument to the
\code{quantile()} function.}
}
\value{
A list containing:
\itemize{
\item \code{D_tilde}: The original matrix \code{D} corrupted with < LOD \code{NA} values.
\item \code{tilde_mask}: A binary matrix of \code{dim(D)} specifying the locations of
corrupted entries (\code{1}) and uncorrupted entries (\code{0}).
\item \code{lod}: A vector with \code{length(lod) == ncol(D)} providing the simulated
LOD values corresponding to each column in the \code{D_tilde}.
}
}
\description{
\code{sim_lod()} simulates putting the columns of a given matrix \code{D} under a limit
of detection (LOD) by calculating the given quantile \code{q} of each column and
corrupting all values < the quantile to \code{NA}, returning the newly corrupted
matrix, the binary corruption mask, and a vector of column LODs.
}
\examples{
D <- sim_data(5, 5, sigma = 0.8)$D
D
sim_lod(D, q = 0.2)
}
\seealso{
\code{\link[=sim_na]{sim_na()}}, \code{\link[=impute_matrix]{impute_matrix()}}, \code{\link[=sim_data]{sim_data()}}
}
