% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvSS.R
\name{mvSS}
\alias{mvSS}
\title{Ease of use multi-value trait model helper function.}
\usage{
mvSS(
  model = "linear",
  form,
  sigma = NULL,
  df,
  start = NULL,
  pars = NULL,
  type = "brms",
  tau = 0.5,
  hierarchy = NULL,
  spectral_index = c("none", "ari", "ci_rededge", "cri550", "cri700", "egi", "evi",
    "gdvi", "mari", "mcari", "mtci", "ndre", "ndvi", "pri", "psnd_chlorophyll_a",
    "psnd_chlorophyll_b", "psnd_caroteniods", "psri", "pssr_chlorophyll_a",
    "pssr_chlorophyll_b", "pssr_caroteniods", "rgri", "rvsi", "savi", "sipi", "sr",
    "vari", "vi_green", "wi", "fvfm", "fqfm")
)
}
\arguments{
\item{model}{A model specification as in \link{growthSS}.}

\item{form}{A formula similar to \code{label | value ~ time + id/group} where label is a column
of histogram bins, value is the counts within those bins, time is an optional time variable,
id identifies an individual, and group contains the treatment groups. If the time variable
is not included then the individual variable should also not be included.}

\item{sigma}{Distributional models passed to \link{growthSS}.}

\item{df}{Data passed to \link{growthSS}.}

\item{start}{Starting values or priors, passed to \link{growthSS}.}

\item{pars}{Parameters to vary, passed to \link{growthSS}.}

\item{type}{Backend to use, passed to \link{growthSS}.}

\item{tau}{Quantile to model, passed to \link{growthSS}.}

\item{hierarchy}{Formulae describing any hierarchical models, see \link{growthSS}.}

\item{spectral_index}{Optionally, a spectral index
\href{https://plantcv.readthedocs.io/en/stable/spectral_index/}{from those calculated by PlantCV}.
If this is given then the appropriate truncation and model family (if applicable)
will be included for the index you are using without you having to write it in the formula.}
}
\value{
A named list of plots showing prior distributions that \code{growthSS} would use,
optionally with a plot of simulated growth curves using draws from those priors.
}
\description{
This function provides a simplified interface to modeling multi-value traits using \link{growthSS}.
Output from this should be passed to \link{fitGrowth} to fit the specified model.
}
\examples{
set.seed(123)
mv_df <- mvSim(dists = list(rnorm = list(mean = 100, sd = 30)), wide = FALSE)
mv_df$group <- rep(c("a", "b"), times = 900)
mv_df <- mv_df[mv_df$value > 0, ]
mv_df$label <- as.numeric(gsub("sim_", "", mv_df$variable))

ss1 <- mvSS(
  model = "linear", form = label | value ~ group, df = mv_df,
  start = list("A" = 5), type = "brms", spectral_index = "none"
)
\donttest{
mod1 <- fitGrowth(ss1, backend = "cmdstanr", iter = 1000, chains = 1, cores = 1)
growthPlot(mod1, ss1$pcvrForm, df = ss1$df)
}

# when the model is longitudinal the same model is possible with growthSS

m1 <- mvSim(
  dists = list(
    rnorm = list(mean = 100, sd = 30),
    rnorm = list(mean = 110, sd = 25),
    rnorm = list(mean = 120, sd = 20),
    rnorm = list(mean = 135, sd = 15)
  ),
  wide = FALSE, n = 6
)
m1$time <- rep(1:4, times = 6 * 180)
m2 <- mvSim(
  dists = list(
    rnorm = list(mean = 85, sd = 25),
    rnorm = list(mean = 95, sd = 20),
    rnorm = list(mean = 105, sd = 15),
    rnorm = list(mean = 110, sd = 15)
  ),
  wide = FALSE, n = 6
)
m2$time <- rep(1:4, times = 6 * 180)
mv_df2 <- rbind(m1, m2)
mv_df2$group <- rep(c("a", "b"), each = 4320)
mv_df2 <- mv_df2[mv_df2$value > 0, ]
mv_df2$label <- as.numeric(gsub("sim_", "", mv_df2$variable))
ss_mv0 <- mvSS(
  model = "linear", form = label | value ~ group, df = mv_df2,
  start = list("A" = 50), type = "brms", spectral_index = "ci_rededge"
)
ss_mv0 # non longitudinal model setup

ss_mv1 <- mvSS(
  model = "linear", form = label | value ~ time | group, df = mv_df2,
  start = list("A" = 50), type = "brms", spectral_index = "ci_rededge"
)
ss_mv1
ss_mv2 <- growthSS(
  model = "skew_normal: linear",
  form = label | resp_weights(value) + trunc(lb = -1, ub = Inf) ~ time | group,
  df = mv_df2, start = list("A" = 50)
)
ss_mv2
# ignoring environments and other such details these are identical except for the
# function call.
unlist(lapply(names(ss_mv1), function(nm) {
  if (!identical(ss_mv1[[nm]], ss_mv2[[nm]],
    ignore.environment = TRUE,
    ignore.srcref = TRUE
  )) {
    if (!identical(as.character(ss_mv1[[nm]]), as.character(ss_mv2[[nm]]))) {
      nm
    }
  }
}))

\donttest{
if (rlang::is_installed("mnormt")) {
  m2 <- fitGrowth(ss_mv1, backend = "cmdstanr", iter = 1000, chains = 1, cores = 1)
  growthPlot(m2, ss_mv1$pcvrForm, df = ss_mv1$df)
}
}

}
\seealso{
\link{fitGrowth} for fitting the model specified by this list.
}
\keyword{multi-value}
