% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/form-other.R
\name{form_estimate}
\alias{form_estimate}
\title{Create a pdqr-function for distribution of sample estimate}
\usage{
form_estimate(f, stat, sample_size, ..., n_sample = 10000,
  args_new = list())
}
\arguments{
\item{f}{A pdqr-function.}

\item{stat}{Statistic function. Should be able to accept numeric vector of
size \code{sample_size} and return single numeric or logical output.}

\item{sample_size}{Size of sample for which distribution of sample estimate
is needed.}

\item{...}{Other arguments for \code{stat}.}

\item{n_sample}{Number of elements to generate from distribution of sample
estimate.}

\item{args_new}{List of extra arguments for \link[=new-pdqr]{new_*()} function to
control \code{\link[=density]{density()}}.}
}
\value{
A pdqr-function of the same \link[=meta_class]{class} and
\link[=meta_type]{type} (if not forced otherwise in \code{args_new}) as \code{f}.
}
\description{
Based on pdqr-function, statistic function, and sample size describe the
distribution of sample estimate. This might be useful for statistical
inference.
}
\details{
General idea is to create a sample from target distribution by
generating \code{n_sample} samples of size \code{sample_size} and compute for each of
them its estimate by calling input \code{stat} function. If created sample is
logical, \strong{boolean} pdqr-function (type "discrete" with elements being
exactly 0 and 1) is created with probability of being true estimated as share
of \code{TRUE} values (after removing possible \code{NA}). If sample is numeric, it is
used as input to \verb{new_*()} of appropriate class with \code{type} equal to type of
\code{f} (if not forced otherwise in \code{args_new}).

\strong{Notes}:
\itemize{
\item This function may be very time consuming for large values of \code{n_sample} and
\code{sample_size}, as total of \code{n_sample*sample_size} numbers are generated and
\code{stat} function is called \code{n_sample} times.
\item Output distribution might have a bias compared to true distribution of
sample estimate. One useful technique for bias correction: compute mean value
of estimate using big \code{sample_size} (with \code{mean(as_r(f)(sample_size))}) and
then recenter distribution to actually have that as a mean.
}
}
\examples{
# These examples take some time to run, so be cautious
\donttest{
set.seed(101)

# Type "discrete"
d_dis <- new_d(data.frame(x = 1:4, prob = 1:4 / 10), "discrete")
## Estimate of distribution of mean
form_estimate(d_dis, stat = mean, sample_size = 10)
## To change type of output, supply it in `args_new`
form_estimate(
  d_dis, stat = mean, sample_size = 10,
  args_new = list(type = "continuous")
)

# Type "continuous"
d_unif <- as_d(dunif)
## Supply extra named arguments for `stat` in `...`
plot(form_estimate(d_unif, stat = mean, sample_size = 10, trim = 0.1))
lines(
  form_estimate(d_unif, stat = mean, sample_size = 10, trim = 0.3),
  col = "red"
)
lines(
  form_estimate(d_unif, stat = median, sample_size = 10),
  col = "blue"
)

# Statistic can return single logical value
d_norm <- as_d(dnorm)
all_positive <- function(x) {
  all(x > 0)
}
## Probability of being true should be around 0.5^5
form_estimate(d_norm, stat = all_positive, sample_size = 5)
}

}
\seealso{
Other form functions: 
\code{\link{form_mix}()},
\code{\link{form_regrid}()},
\code{\link{form_resupport}()},
\code{\link{form_retype}()},
\code{\link{form_smooth}()},
\code{\link{form_tails}()},
\code{\link{form_trans}()}
}
\concept{form functions}
