% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_cite.R
\name{ps_cite}
\alias{ps_cite}
\title{Get \code{BibTeX} Entries Associated with \pkg{peacesciencer} Data and Functions}
\usage{
ps_cite(x, column = "keywords")
}
\arguments{
\item{x}{a character vector}

\item{column}{a character vector for the particular column of \code{ps_bib} the user wants to search. The default here is \code{"keywords"},
which searches the \code{KEYWORDS} column in \code{ps_bib} for the most general search. The other option is \code{"bibtexkey"}, which will
search the \code{BIBTEXKEY} column in \code{ps_bib}. Use the latter option more for pairing with output from \code{ps_version()}}
}
\value{
\code{ps_cite()} takes a character vector and scans the \code{ps_bib} data in
this package to return a \code{BibTeX} citation (or citations) for the researcher to use
to properly cite the material they are getting from this package. The citations
are returned as a full \code{BibTeX} entry (or entries) that they can copy-paste into their
own \code{BibTeX} file.
}
\description{
\code{ps_cite()} allows the user to get citations to scholarship that they
should include in their papers that incorporate the functions and data in this package.
}
\details{
The base functionality here is simple pattern-matching on keywords in \code{ps_bib}. This
simple pattern-matching is in base R. I assume the user has some familiarity with \code{BibTeX}.
}
\examples{

# Cite the package
ps_cite("peacesciencer")


}
\author{
Steven V. Miller
}
