% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rpg_scalar}
\alias{rpg_scalar}
\alias{rpg_vector}
\alias{rpg_hybrid}
\alias{rpg_gamma}
\alias{rpg_devroye}
\alias{rpg_sp}
\alias{rpg_normal}
\title{Sample from the Polya Gamma distribution PG(h, z)}
\usage{
rpg_scalar(h, z)

rpg_vector(n, h, z)

rpg_hybrid(h, z)

rpg_gamma(h, z, trunc = 1000L)

rpg_devroye(h, z)

rpg_sp(h, z)

rpg_normal(h, z)
}
\arguments{
\item{h}{\code{integer} values corresponding to the "shape" parameter.}

\item{z}{\code{numeric} values corresponding to the "scale" parameter.}

\item{n}{The number of samples to taken from a PG(h, z). Used only by
the vector sampler.}

\item{trunc}{Truncation cut-off. Only used by the gamma sampler.}
}
\value{
A single \code{numeric} value.
}
\description{
Chooses the most efficient implemented method to sample from a Polya Gamma
distribution. Details on algorithm selection presented below.
}
\details{
The following sampling cases are enabled:
\itemize{
\item \code{h > 170}: Normal approximation method
\item \code{h > 13}: Saddlepoint approximation method
\item \code{h = 1} or \code{h = 2}: Devroye method
\item \code{h > 0}: Sum of Gammas method.
\item \code{h < 0}: Result is automatically set to zero.
}
}
\examples{
# Fixed parameter distribution simulation ----

## Parameters  ----
h = 1; z = .5

## Sample only one value  ----
single_value = rpg_scalar(h, z)
single_value

## Attempt distribution recovery  ----
vector_of_pg_samples = rpg_vector(1e6, h, z)

head(vector_of_pg_samples)
length(vector_of_pg_samples)

## Obtain the empirical results   ----
empirical_mean = mean(vector_of_pg_samples)
empirical_var = var(vector_of_pg_samples)

## Take the theoretical values ----
theoretical_mean = pg_mean(h, z)
theoretical_var = pg_var(h, z)

## Form a comparison table ----

# empirically sampled vs. theoretical values
rbind(c(empirical_mean, theoretical_mean),
      c(empirical_var, theoretical_var))

# Varying distribution parameters ----

## Generate varying parameters ----
u_h = 20:100
u_z = 0.5*u_h

## Sample from varying parameters ----
x = rpg_hybrid(u_h, u_z)
}
