% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGibbsSumamry.R
\name{getGibbsSummary}
\alias{getGibbsSummary}
\title{Summarize Output of the CDM Model}
\usage{
getGibbsSummary(ssOut, burnin = NULL, colNames = NULL,
  sigmaPerSeason = TRUE)
}
\arguments{
\item{ssOut}{CDM output list.}

\item{burnin}{Number of burnin itterations .}

\item{colNames}{vector of charachters includes names of each variable in the output.}

\item{sigmaPerSeason}{logical value indicating whether each site/season has a separate process error}
}
\description{
This function return a summary of the output from the Gibbs-Sampling of the CDM model.
}
\examples{

#Summarize CDM Model Ouput

ssSim <- phenoSim(nSites = 2, #number of sites
                  nTSet = 30, #number of Time steps
                  beta = c(1, 2), #beta coefficients
                  sig = .01, #process error
                  tau = .1, #observation error
                  plotFlag = TRUE, #whether plot the data or not
                  miss = 0.05, #fraction of missing data
                  ymax = c(6, 3) #maximum of saturation trajectory
)

ssOut <- fitCDM(x = ssSim$x, #predictors
                nGibbs = 200,
                nBurnin = 100,
                z = ssSim$z,#response
                connect = ssSim$connect, #connectivity of time data
                quiet=TRUE)

summ <- getGibbsSummary(ssOut, burnin = 100, sigmaPerSeason = FALSE)

colMeans(summ$ymax)
colMeans(summ$betas)
colMeans(summ$tau)
colMeans(summ$sigma)

}
\keyword{Gibbs}
\keyword{Output}
\keyword{Sammary}
\keyword{Sampling}
