% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filters-mspct.r
\docType{data}
\name{filters_UVIVIF.mspct}
\alias{filters_UVIVIF.mspct}
\title{Spectral fluorescence of diverse optical filters}
\format{
A \code{"source_mspct"} object containing several
  \code{"source_spct"}.
}
\usage{
filters_UVIVIF.mspct
}
\description{
A collection of ultraviolet-A-induced visible and near infrared fluorescence
spectra for optical filters.
}
\details{
The \code{"source_mspct"} object named \code{filters_UVIVIF.mspct}
  contains a collection of \code{"source_spct"} objects with spectral
  fluorescence emission data for filters illuminated with ultraviolet-A
  radiation at 365 nm.

  The variables in each member spectrum are as follows: \itemize{ \item
  \code{w.length} (nm) \item \code{s.q.irrad} photon irradiance (mol m-2 s-1)}
  These member objects contain metadata stored as R attributes. Accessors are
  available to the metadata: \code{what_measured()}, \code{how_measured()},
  \code{when_measured()}, \code{filter_properties()} and \code{comment()}.

  The member spectra are
  named consistently with the transmittance spectra in the collection
  \code{\link{filters.mspct}}. Currently all members of
  \code{filters_UVIVIF.mspct} are ionic glass photography filters.
}
\note{
Please see the metadata for specific details. Accessors are
  available to the metadata: \code{\link[photobiology]{what_measured}()},
  \code{\link[photobiology]{how_measured}()},
  \code{\link[photobiology]{when_measured}()},
  \code{\link[photobiology]{filter_properties}()} and
  \code{\link[base]{comment}()}.
}
\examples{
names(filters_UVIVIF.mspct)
filters_UVIVIF.mspct$Hoya_25A_HMC_2.3mm_52mm

what_measured(filters_UVIVIF.mspct$Hoya_25A_HMC_2.3mm_52mm)
cat(how_measured(filters_UVIVIF.mspct$Hoya_25A_HMC_2.3mm_52mm))
cat(comment(filters_UVIVIF.mspct$Hoya_25A_HMC_2.3mm_52mm))

}
\keyword{datasets}
