% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.t.r
\name{GEN_T}
\alias{GEN_T}
\title{Constructor of GPAS (Thimijan's formulation) weighted waveband}
\usage{
GEN_T(norm = 300, w.low = 275, w.high = 345)
}
\arguments{
\item{norm}{normalization wavelength (nm)}

\item{w.low}{short-end boundary wavelength (nm)}

\item{w.high}{long-end boundary wavelength (nm)}
}
\value{
a waveband object wavelength defining wavelength range, weighting
  function and normalization wavelength.
}
\description{
Generalized Plant Action BSWF of Caldwell [1] as formulated by Timijan et al.
[2]
}
\examples{
GEN_T()
GEN_T(300)

}
\references{
[1] Caldwell, M. M. (1971) Solar UV irradiation and the growth
and development of higher plants. In Giese, A. C. (Ed.) Photophysiology,
Academic Press, 1971, 6, 131-177

[2] Thimijan RW, Cams HR, Campbell L. (1978) Radiation sources and related
environmental control for biological and climatic eflFects of UV research.
Final report EPA-IAG-D6-0168. Washington: Environmental Protection Agency.
}
\seealso{
\code{\link{GEN.G}} \code{\link{GEN.M}} \code{\link{PG}}
  and \code{\link[photobiology]{waveband}}

Other BSWF weighted wavebands: 
\code{\link{CH4}()},
\code{\link{DNA_GM}()},
\code{\link{DNA_N}()},
\code{\link{DNA_P}()},
\code{\link{FLAV}()},
\code{\link{GEN_G}()},
\code{\link{GEN_M}()},
\code{\link{PAR}()},
\code{\link{PG}()},
\code{\link{UV_health_hazard}()},
\code{\link{erythema}()}
}
\concept{BSWF weighted wavebands}
