% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eq11.R
\name{eq11}
\alias{eq11}
\title{Calculate Photosynthetic Rates Using a Nonlinear Model EQ11}
\usage{
eq11(pars = c(phi_I0_Icomp = .0756, beta = .0000432, gamma = .0039, Icomp = 22.6),
     data,
     PARi = c(0, 50, 100, 250, 500, 1000, 1500, 2000, 2500),
     return = c("predict","calc","all")[1])
}
\arguments{
\item{pars}{A named vector of parameters. Default values are phi_I0_Icomp = .0756, beta = .0000432, gamma = .0039, Icomp = 22.6. These serve as initial starting parameters for the function to rapidly assess your data through an iterative process. The empirical values beta and gamma range between 0 and 1, and are not explicitly described by Ye (2007) but are independent coefficients of I implemented to incorporate a more dynamic response to light. All of these values may be changed to fall within the minimum and maximum parameter values of your study system.}

\item{data}{A data frame containing the experimental data with at least two columns: 'PARi' for the incident light and 'A' for the photosynthetic rate.}

\item{PARi}{A numeric vector of incident light values. Defaults to a sequence from 0 to 2500.}

\item{return}{Character string indicating what the function should return. Options are "predict" for predicted values, "calc" for calculated quantities, and "all" for both. Defaults to "predict".}
}
\value{
Depending on the 'return' argument, the function returns:
\itemize{
\item \code{"predict"}: A numeric vector of predicted photosynthetic rates.
\item \code{"calc"}: A named vector of calculated quantities:
Pgmax,
Pmax,
Icomp,
phi_I0 (quantum yield calculated at I0),
phi_Icomp (quantum yield calculated at Icomp),
phi_I0_Icomp (quantum yield calculated by the range of values between I0 and Icomp),
phi_Icomp_I200 (quantum yield calculated by the range between Icomp and I200),
Rd (dark respiration),
Imax (Imax calculated),
Imax_obs (Imax observed),
P_Imax (assimilation value at maximum light),
Isat_x, x = .25, .50, .75, .85, .90, .95 (light saturation at x percent of Pmax),
Ix, x = .25, .50, .75, .85, .90, .95 (light intensity at x percent of Pmax)
\item \code{"all"}: A list containing both the predicted values, calculated quantities, and model fit statistics.
}
}
\description{
Uses the nonlinear least squares Ye model equation 11 from Lobo et. al (2013) to transform measured photosynthetic data into a smoothed function-valued trait with the following function:
A~phi_I0_Icomp((1-beta(PARi))/(1+gamma(PARi)))(PARi-Icomp)
The function will return predicted values, calculated quantities, or both.
}
\details{
The function uses the provided data to estimate the parameters phi_I0_Icomp, Icomp, and empirical parameters beta and gamma by minimizing the squared differences between observed and predicted photosynthetic rates. The model is then used to calculate a range of derived functional trait quantities such as the dark respiration rate (Rd), light compensation point (Icomp), maximum photosynthetic rate (Pmax), and curve derived parameters (Ix) among other calculated quantities.
}
\examples{
    # Example dataset
    data(sunflowers)
    example_data <- sunflowers |> filter(SampleID==SampleID[1])
    # Predict photosynthetic rates given the parameters
    predicted_values <- eq11(return = "predict")
    print(predicted_values)

    # Use experimental data to predict photosynthetic rates and estimate linear parameters
    result <- eq11(data = example_data, return = "all")
    print(result$calc)  # View calculated quantities
    print(result$fit)   # View fit statistics and optimized parameters

    # Get calculated quantities directly
    calculated_quantities <- eq11(data = example_data, return = "calc")
    print(calculated_quantities)

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{Lobo, F. de A., M. P. de Barros, H. J. Dalmagro,  .C. Dalmolin, W. E. Pereira, É.C. de Souza, G. L. Vourlitis and C. E. Rodriguez Ortiz 2013 Fitting net photosynthetic light-response curves with Microsoft Excel – a critical look at the models. Photosynthetica 51 (3): 445-456.

Ye, Z.-P. 2007 A new model for relationship between irradiance and the rate of photosynthesis in *Oryza sativa*. Photosynthetica 45: 637-640.

Davis, R.E., C. M. Mason, E. W. Goolsby 2024 Comparative evolution of photosynthetic light response curve: approaches and pitfalls in phylogenetic modeling of a function-valued trait. IJPS, in review
}\if{html}{\out{</div>}}
}
