% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{get_default_model}
\alias{get_default_model}
\alias{get_all_models}
\alias{marshall_biscoe_1980}
\alias{photoinhibition}
\title{Get default model}
\usage{
get_default_model(.photo_fun)

get_all_models(method)

marshall_biscoe_1980(Q_abs, k_sat, phi_J, theta_J)

photoinhibition(Q_abs, k_sat, phi_J, theta_J, b_inh)
}
\arguments{
\item{.photo_fun}{A character string of \strong{photosynthesis} function to call. One of: \verb{aq_response, r_light}.}

\item{method}{A character string of the statistical method to use: 'ls' for least-squares and 'brms' for Bayesian model using \code{\link[brms:brm]{brms::brm()}}. Default is 'ls'.}

\item{Q_abs}{Absorbed light intensity (\eqn{\mu}mol m\eqn{^{-2}} s\eqn{^{-1}})}

\item{k_sat}{Light saturated rate of process k}

\item{phi_J}{Quantum efficiency of process k}

\item{theta_J}{Curvature of the light response}

\item{b_inh}{Inhibition parameter}
}
\value{
A character string with name of model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Get the name of the default model used for different plant ecophysiological data analysis methods implemented in \strong{photosynthesis}. Currently only used for \code{\link[=fit_aq_response2]{fit_aq_response2()}} and \code{\link[=fit_r_light2]{fit_r_light2()}}.

\strong{Light response models:}
\itemize{
\item \code{marshall_biscoe_1980()}: Non-rectangular hyperbolic model of light responses
\item \code{photoinhibition()}: Non-rectangular hyperbolic model of light responses with photoinhibition of \code{k_sat} at increasing Q_abs
}
}
\examples{
get_default_model("aq_response")
get_default_model("r_light")

}
