% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chi_check.R
\name{chi_check}
\alias{chi_check}
\title{Check the validity of a CHI number}
\usage{
chi_check(x)
}
\arguments{
\item{x}{a CHI number or a vector of CHI numbers with \code{character} class.}
}
\value{
\code{chi_check} returns a character string. Depending on the
validity of the entered CHI number, it will return one of the following:
\itemize{
\item \verb{Valid CHI}
\item \verb{Invalid character(s) present}
\item \verb{Too many characters}
\item \verb{Too few characters}
\item \verb{Invalid date}
\item \verb{Invalid checksum}
\item \code{Missing (NA)}
\item \code{Missing (Blank)}
}
}
\description{
\code{chi_check} takes a CHI number or a vector of CHI numbers
with \code{character} class. It returns feedback on the validity of the
entered CHI number and, if found to be invalid, provides an explanation as
to why.
}
\details{
The Community Health Index (CHI) is a register of all patients in
NHS Scotland. A CHI number is a unique, ten-digit identifier assigned to
each patient on the index.

The first six digits of a CHI number are a patient's date of birth in
DD/MM/YY format.

The ninth digit of a CHI number identifies a patient's sex: odd for male,
even for female. The tenth digit is a check digit, denoted \code{checksum}.

While a CHI number is made up exclusively of numeric digits, it cannot be
stored with \code{numeric} class in R. This is because leading zeros in
numeric values are silently dropped, a practice not exclusive to R. For this
reason, \code{chi_check} accepts input values of \code{character} class
only. A leading zero can be added to a nine-digit CHI number using
\code{\link[=chi_pad]{chi_pad()}}.

\code{chi_check} assesses whether an entered CHI number is valid by checking
whether the answer to each of the following criteria is \code{Yes}:
\itemize{
\item Does it contain no non-numeric characters?
\item Is it ten digits in length?
\item Do the first six digits denote a valid date?
\item Is the checksum digit correct?
}
}
\examples{
chi_check("0101011237")
chi_check(c("0101201234", "3201201234"))

library(dplyr)
df <- tibble(chi = c(
  "3213201234",
  "123456789",
  "12345678900",
  "010120123?",
  NA
))
df \%>\%
  mutate(validity = chi_check(chi))
}
