% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/file_size.R
\name{file_size}
\alias{file_size}
\title{Calculate file size}
\usage{
file_size(filepath = getwd(), pattern = NULL)
}
\arguments{
\item{filepath}{A character string denoting a filepath. Defaults to the
working directory, \code{getwd()}.}

\item{pattern}{An optional character string denoting a
\code{\link[base:regex]{regular expression()}} pattern. Only file names which
match the regular expression will be returned. See the \strong{See Also}
section for resources regarding how to write regular expressions.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} listing the names of files within
\code{filepath} which match \code{pattern} and their respective sizes. The
column names of this tibble are \code{name} and \code{size}. If no \code{pattern} is
specified, \code{file_size} returns the names and sizes of all files within
\code{filepath}. File names and sizes are returned in alphabetical order of
file name. Sub-folders contained within \code{filepath} will return a file
size of \verb{0 B}.

If \code{filepath} is an empty folder, or \code{pattern} matches no files
within \code{filepath}, \code{file_size} returns \code{NULL}.
}
\description{
\code{file_size} takes a filepath and an optional regular
expression pattern. It returns the size of all files within that directory
which match the given pattern.
}
\details{
The sizes of files with certain extensions are returned with the
type of file prefixed. For example, the size of a 12 KB \code{.xlsx} file is
returned as \verb{Excel 12 KB}. The complete list of explicitly catered-for file
extensions and their prefixes are as follows:

\itemize{
\item \code{.xls}, \code{.xlsb}, \code{.xlsm} and \code{.xlsx} files are
prefixed with \code{Excel}
\item \code{.csv} files are prefixed with \code{CSV}
\item \code{.sav} and \code{.zsav} files are prefixed with \code{SPSS}
\item \code{.doc}, \code{.docm} and \code{.docx} files are prefixed with
\code{Word}
\item \code{.rds} files are prefixed with \code{RDS}
\item \code{.txt} files are prefixed with \code{Text},
\item \code{.fst} files are prefixed with \code{FST},
\item \code{.pdf} files are prefixed with \code{PDF},
\item \code{.tsv} files are prefixed with \code{TSV},
\item \code{.html} files are prefixed with \code{HTML},
\item \code{.ppt}, \code{.pptm} and \code{.pptx} files are prefixed with
\code{PowerPoint},
\item \code{.md} files are prefixed with \code{Markdown}
}

Files with extensions not contained within this list will have their size
returned with no prefix. To request that a certain extension be explicitly
catered for, please create an issue on
\href{https://github.com/Public-Health-Scotland/phsmethods/issues}{GitHub}.

File sizes are returned as the appropriate multiple of the unit byte
(bytes (B), kilobytes (KB), megabytes (MB), etc.). Each multiple is taken to
be 1,024 units of the preceding denomination.
}
\examples{
# Name and size of all files in working directory
file_size()

# Name and size of .xlsx files only in working directory
file_size(pattern = "\\\\.xlsx$")

# Size only of alphabetically first file in working directory
library(magrittr)
file_size() \%>\%
  dplyr::pull(size) \%>\%
  extract(1)

}
\seealso{
For more information on using regular expressions, see this
\href{https://www.jumpingrivers.com/blog/regular-expressions-every-r-programmer-should-know/}{Jumping Rivers blog post}
and this
\href{https://stringr.tidyverse.org/articles/regular-expressions.html}{vignette}
from the \code{\link[stringr:stringr-package]{stringr()}} package.
}
