% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob_trans_stsl.R
\name{prob_trans_stsl}
\alias{prob_trans_stsl}
\title{Probability of transmission assuming single-transmission and single-linkage}
\usage{
prob_trans_stsl(eta, chi, rho, M)
}
\arguments{
\item{eta}{scalar or vector giving the sensitivity of the linkage criteria}

\item{chi}{scalar or vector giving the specificity of the linkage criteria}

\item{rho}{scalar or vector giving the proportion of the final outbreak size that is sampled}

\item{M}{scalar or vector giving the number of cases sampled}
}
\value{
scalar or vector giving the probability of transmission between two cases given linkage by phylogenetic criteria
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
This function calculates the probability that two cases are linked by direct transmission
given that they have been linked by phylogenetic criteria. The single-transmission and single-linkage method assumes the following:
\enumerate{
\item Each case \eqn{i} is linked by transmission to only one other case \eqn{j} in the population (\eqn{N}).
\item Each case \eqn{i} is linked by the linkage criteria to only one other case \eqn{j} in the sampled population (\eqn{M}).
}

For perfect sensitivity, set \code{eta = 1}.
}
\examples{
# perfect sensitivity and specificity
prob_trans_stsl(eta=1, chi=1, rho=0.2, M=100)

# perfect sensitivity only
prob_trans_stsl(eta=1, chi=0.95, rho=0.2, M=100)

prob_trans_stsl(eta=0.99, chi=0.95, rho=0.9, M=50)

prob_trans_stsl(eta=0.99, chi=0.95, rho=0.05, M=100)

}
\seealso{
Other prob_trans: 
\code{\link{prob_trans_mtml}()},
\code{\link{prob_trans_mtsl}()}
}
\author{
John Giles, Shirlee Wohl, and Justin Lessler
}
\concept{prob_trans}
