% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_canape.R
\name{ps_canape}
\alias{ps_canape}
\title{Categorical Analysis of Neo- and Paleo-Endemism (CANAPE)}
\usage{
ps_canape(rand, alpha = 0.05)
}
\arguments{
\item{rand}{An object returned by running \code{ps_rand}. It must include the metrics PE, RPE, and CE,
and must have been computed with \code{summary = "quantile"}.}

\item{alpha}{Numeric value between 0 and 1 giving the one-tailed p-value threshold to use when
determining significance.}
}
\value{
An object of the same class as \code{rand} containing a variable called \code{"canape"}, with values 0-4
corresponding to not-significant, mixed-, super-, neo-, and paleo-endemism, respectively.
}
\description{
This function classifies sites into areas of significant endemism according to the scheme of Mishler et al. (2014).
Categorization is based on randomization quantile values for PE, RPE, and CE (which Mishler et al. call "PE on
the comparison tree").
}
\details{
Endemism significance categories are defined as follows:
\itemize{
\item Endemism not significant: neither PE nor CE are significantly high at \code{alpha}.
\item Significant neoendemism: PE or CE are significantly high at \code{alpha}; RPE significantly low at \code{alpha / 2} (two-tailed test).
\item Significant paleoendemism: PE or CE are significantly high at \code{alpha}; RPE significantly high at \code{alpha / 2} (two-tailed test)..
\item Significant mixed-endemism: PE or CE are significantly high at \code{alpha}; RPE not significant.
\item Significant super-endemism: PE or CE are significantly high at \code{alpha / 5}; RPE not significant.
}
}
\examples{
\donttest{
# classic CANAPE using binary data and the curveball algorithm
# (note that a real analysis would require a much higher `n_rand`)
set.seed(123456)
ps <- ps_simulate(data_type = "binary")
rand <- ps_rand(ps, metric = c("PE", "RPE", "CE"),
                fun = "nullmodel", method = "curveball",
                n_rand = 25, burnin = 10000, progress = FALSE)
canape <- ps_canape(rand)
terra::plot(canape)
}

}
\references{
Mishler, B. D., Knerr, N., González-Orozco, C. E., Thornhill, A. H., Laffan, S. W., & Miller, J. T. (2014).
Phylogenetic measures of biodiversity and neo-and paleo-endemism in Australian Acacia. Nature Communications, 5(1), 4473.
}
