% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dea-utils.R
\name{compute_scale_efficiency}
\alias{compute_scale_efficiency}
\title{Calculate scale efficiency}
\usage{
compute_scale_efficiency(x, y, orientation = c("in", "out"), digits = NULL)
}
\arguments{
\item{x}{A matrix of inputs, created with \code{create_matrix}}

\item{y}{A matrix of outputs, created with \code{create_matrix}}

\item{orientation}{\verb{in} for input oriented models or \code{out} for output oriented}

\item{digits}{An integer with the number of digits to round to. If \code{NULL} the
values are kept unrounded.}
}
\value{
A data frame containing the efficiency scores for CRS, VRS, the
Scale Efficiency, the VRS to NIRS ratio, and a recommendation on whether to
increase or decrease the size of the DMU.
}
\description{
Calculate scale efficiency from a set of inputs and outputs and return a
data.frame
}
\examples{
# Create matrices with random values
inputs <- matrix(runif(10, 1, 10), ncol = 2)
outputs <- matrix(runif(10, 1, 10), ncol = 2)
# Compute scale efficiency
res <- compute_scale_efficiency(
  inputs, outputs, orientation = 'out', digits = 2)
}
