% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PivotLatexRenderer.R
\docType{class}
\name{PivotLatexRenderer}
\alias{PivotLatexRenderer}
\title{R6 class that renders a pivot table in Latex.}
\format{
\code{\link[R6]{R6Class}} object.
}
\description{
The `PivotLatexRenderer` class creates a Latex representation of a pivot table.
}
\examples{
# This class should only be created by the pivot table.
# It is not intended to be created outside of the pivot table.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PivotLatexRenderer-new}{\code{PivotLatexRenderer$new()}}
\item \href{#method-PivotLatexRenderer-clearIsRenderedFlags}{\code{PivotLatexRenderer$clearIsRenderedFlags()}}
\item \href{#method-PivotLatexRenderer-resetVisibleRange}{\code{PivotLatexRenderer$resetVisibleRange()}}
\item \href{#method-PivotLatexRenderer-setVisibleRange}{\code{PivotLatexRenderer$setVisibleRange()}}
\item \href{#method-PivotLatexRenderer-getTableLatex}{\code{PivotLatexRenderer$getTableLatex()}}
\item \href{#method-PivotLatexRenderer-clone}{\code{PivotLatexRenderer$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotLatexRenderer-new"></a>}}
\if{latex}{\out{\hypertarget{method-PivotLatexRenderer-new}{}}}
\subsection{Method \code{new()}}{
Create a new `PivotLatexRenderer` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotLatexRenderer$new(parentPivot = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parentPivot}}{The pivot table that this `PivotLatexRenderer`
instance belongs to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `PivotLatexRenderer` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotLatexRenderer-clearIsRenderedFlags"></a>}}
\if{latex}{\out{\hypertarget{method-PivotLatexRenderer-clearIsRenderedFlags}{}}}
\subsection{Method \code{clearIsRenderedFlags()}}{
An internal method used when rendering a pivot table to Latex
Clear the IsRendered flags that exist on the `PivotDataGroup` class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotLatexRenderer$clearIsRenderedFlags()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotLatexRenderer-resetVisibleRange"></a>}}
\if{latex}{\out{\hypertarget{method-PivotLatexRenderer-resetVisibleRange}{}}}
\subsection{Method \code{resetVisibleRange()}}{
Clears the visible range that has been set, so the next call to
`getTableLatex()` will render the whole table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotLatexRenderer$resetVisibleRange()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotLatexRenderer-setVisibleRange"></a>}}
\if{latex}{\out{\hypertarget{method-PivotLatexRenderer-setVisibleRange}{}}}
\subsection{Method \code{setVisibleRange()}}{
Specifies a subset of the pivot table to be rendered, e.g.
for use when a pivot table will not fit into a single A4 page.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotLatexRenderer$setVisibleRange(
  fromRow = NULL,
  toRow = NULL,
  fromColumn = NULL,
  toColumn = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fromRow}}{The row number to render from.}

\item{\code{toRow}}{The row number to render to.}

\item{\code{fromColumn}}{The column number to render from.}

\item{\code{toColumn}}{The column number to render to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
No return value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotLatexRenderer-getTableLatex"></a>}}
\if{latex}{\out{\hypertarget{method-PivotLatexRenderer-getTableLatex}{}}}
\subsection{Method \code{getTableLatex()}}{
Generate a Latex representation of the pivot table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotLatexRenderer$getTableLatex(
  caption = NULL,
  label = NULL,
  boldHeadings = FALSE,
  italicHeadings = FALSE,
  exportOptions = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{caption}}{The caption to appear above the table.}

\item{\code{label}}{The label to use when referring to the table elsewhere in
the document}

\item{\code{boldHeadings}}{Default `FALSE`, specify `TRUE` to render headings
in bold.}

\item{\code{italicHeadings}}{Default `FALSE`, specify `TRUE` to render headings
in italic.}

\item{\code{exportOptions}}{A list of additional export options - see the
"A1. Appendix" for details.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A character variable containing the Latex representation of
the pivot table.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PivotLatexRenderer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PivotLatexRenderer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PivotLatexRenderer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
