% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{repo_auth}
\alias{repo_auth}
\title{Authenticated repositories}
\usage{
repo_auth(
  r_version = getRversion(),
  bioc = TRUE,
  cran_mirror = default_cran_mirror(),
  check_credentials = TRUE
)
}
\arguments{
\item{r_version}{R version(s) to use for the Bioconductor repositories,
if \code{bioc} is \code{TRUE}.}

\item{bioc}{Whether to add Bioconductor repositories, even if they
are not configured in the \code{repos} option.}

\item{cran_mirror}{The CRAN mirror to use, see
\code{\link[=default_cran_mirror]{default_cran_mirror()}}.}

\item{check_credentials}{Whether to check that credentials are
available for the authenticated repositories.}
}
\value{
Data frame with columns:
\itemize{
\item all columns from the output of \code{\link[=repo_get]{repo_get()}},
\item \code{auth_domains}: authentication domains. pkgcache tries to find the
credentials for these domains, until the search is successful or all
domains fail. This column is a list column of character vectors.
\item \code{auth_domain}: if the credential lookup is successful, then this is
the authentication domain that was used to get the credentials.
\item \code{auth_source}: where the credentials were found. E.g.
\code{keyring:macos} means it was in the default macos keyring.
\item \code{auth_error}: for failed credential searches this is the description
of why the search failed. E.g. maybe the keyring package is not
installed, or pkgcache found no credentials for any of the
authentication domains.
}
}
\description{
\code{repo_auth()} lists authentication information for all configured
repositories.
}
\details{
pkgcache supports HTTP basic authentication when interacting with
CRAN-like repositories. To use authentication, include a username
in the repo URL:

\if{html}{\out{<div class="sourceCode">}}\preformatted{https://<username>@<repo-host>/<repo-path>
}\if{html}{\out{</div>}}

pkgcache tries to obtain the passwords for the authenticated CRAN-like
repos from two sources, in this order:
\enumerate{
\item A "netrc" file. If the \code{NETRC} environment variable is set, it
should point to a file in "netrc" format. Otherwise pkgcache uses
the \verb{~/.netrc} file in the current user's home directory, if it
exists. On Windows it also tries the \verb{~/_netrc} file.
\item The system's credential store, via the keyring package.
}

See the \href{https://curl.se/libcurl/c/CURLOPT_NETRC.html}{documentation of libcurl} for details about the
format of the netrc file.

When looking for the password in the system credential store, pkgcache
looks at the following keys, in this order:

\if{html}{\out{<div class="sourceCode">}}\preformatted{https://<username>@repo-host/<repo-path>
https://repo-host/<repo-path>
https://<username>@repo-host
https://repo-host
}\if{html}{\out{</div>}}

To add an authenticated repository use \code{\link[=repo_add]{repo_add()}} with the \code{username}
argument. Alternatively, you can set the \code{repos} option directly using
\code{\link[base:options]{base::options()}} and including the username in the repository URL.
}
