% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphClasses.R
\name{AbstractGraph}
\alias{AbstractGraph}
\title{Base class for Graphs}
\description{
pkgnet uses R6 classes to define and encapsulate the graph
models for representing package networks. These classes implement
different types of graphs and functionality to calculate their respective
graph theory measures. The base class \code{AbstractGraph} defines the
standard interfaces and functionality.

Currently the only implemented type of graph is \link{DirectedGraph}.
}
\concept{Graph Classes}
\keyword{internal}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{nodes}}{node data.table, read-only.}

\item{\code{edges}}{edge data.table, read-only.}

\item{\code{igraph}}{igraph object, read-only.}

\item{\code{available_node_measures}}{character vector of all supported node measures. 
See \emph{Node Measures} section in \link{DirectedGraphMeasures} for details about each measure.}

\item{\code{available_graph_measures}}{character vector of all supported graph measures. 
See \emph{Graph Measures} section in \link{DirectedGraphMeasures} for details about each measure. Read-only.}

\item{\code{default_node_measures}}{character vector of default node measures. 
See \emph{Node Measures} section in \link{DirectedGraphMeasures} for details about each measure.}

\item{\code{default_graph_measures}}{character vector of default graph measures. 
See \emph{Graph Measures} section in \link{DirectedGraphMeasures} for details about each measure. Read-only.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AbstractGraph-new}{\code{AbstractGraph$new()}}
\item \href{#method-AbstractGraph-node_measures}{\code{AbstractGraph$node_measures()}}
\item \href{#method-AbstractGraph-graph_measures}{\code{AbstractGraph$graph_measures()}}
\item \href{#method-AbstractGraph-print}{\code{AbstractGraph$print()}}
\item \href{#method-AbstractGraph-clone}{\code{AbstractGraph$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraph-new"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraph-new}{}}}
\subsection{Method \code{new()}}{
Instantiate new object of the class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraph$new(nodes, edges)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nodes}}{a data.table containing nodes}

\item{\code{edges}}{a data.table containing edges}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraph-node_measures"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraph-node_measures}{}}}
\subsection{Method \code{node_measures()}}{
Return specified node-level measures, calculating if necessary.
See \emph{Node Measures} section in \link{DirectedGraphMeasures} for details about each measure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraph$node_measures(measures = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{character vector of measure names. 
Default NULL will return those that are already calculated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a data.table with specified node meaures as columns
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraph-graph_measures"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraph-graph_measures}{}}}
\subsection{Method \code{graph_measures()}}{
Return specified graph-level measures, calculating if necessary. 
See \emph{Graph Measures} section in \link{DirectedGraphMeasures} for details about each measure.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraph$graph_measures(measures = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{measures}}{character vector of measure names. 
Default NULL will return those that are already calculated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
list with specified graph measures.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraph-print"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraph-print}{}}}
\subsection{Method \code{print()}}{
print igraph object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraph$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Self, invisibly.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AbstractGraph-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AbstractGraph-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AbstractGraph$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
