% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hit_grid.R
\name{hit_grid}
\alias{hit_grid}
\title{Plots multiple platemaps with and identifies hits}
\usage{
hit_grid(
  data,
  well,
  plate_id,
  threshold = 2,
  ncols = 2,
  plate = 96,
  each = FALSE,
  scale_each = FALSE,
  palette = "Spectral",
  ...
)
}
\arguments{
\item{data}{Numerical values to be scaled and plotted}

\item{well}{Vector of well identifiers. e.g "A01"}

\item{plate_id}{Vector of plate identifiers e.g "Plate_1"}

\item{threshold}{Numerical value of standard deviations from the mean
for a well to be classified as a 'hit'. Default it +/- 2 SD}

\item{ncols}{Number of columns in the grid of plates}

\item{plate}{Number of wells in the complete plates (96, 384 or 1536)}

\item{each}{boolean, allowed for backwards compatibility, \code{scale_each}
is now the preferred argument name}

\item{scale_each}{boolean, if true scales each plate individually, if false
will scale the pooled values of \code{data}}

\item{palette}{RColorBrewer palette}

\item{...}{additional arguments for plot wrappers}
}
\value{
ggplot plot
}
\description{
Converts numerical values and well labels into 'hits' in the form of
multiple plate maps. Hits are calculated as wells above or below a
specified number of standard deviations from the overall average
}
\examples{
df01 <- data.frame(well = num_to_well(1:96),
  vals = rnorm(96),
  plate = 1)

df02 <- data.frame(well = num_to_well(1:96),
  vals = rnorm(96),
  plate = 2)

df <- rbind(df01, df02)

hit_grid(data = df$vals,
    well = df$well,
    plate_id = df$plate,
    plate = 96,
    each = FALSE)
}
