% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvf.R
\name{cvf}
\alias{cvf}
\title{Cross-validation internal function for cv_plmm}
\usage{
cvf(i, fold, type, cv_args, ...)
}
\arguments{
\item{i}{Fold number to be excluded from fit.}

\item{fold}{n-length vector of fold-assignments.}

\item{type}{A character argument indicating what should be returned from predict.plmm. If \code{type == 'lp'} predictions are based on the linear predictor, \code{$X beta$}. If \code{type == 'individual'} predictions are based on the linear predictor plus the estimated random effect (BLUP).}

\item{cv_args}{List of additional arguments to be passed to plmm.}

\item{...}{Optional arguments to \code{predict_within_cv}}
}
\value{
a list with three elements:
\itemize{
\item a numeric vector with the loss at each value of lambda
\item a numeric value indicating the number of lambda values used
\item a numeric value with the predicted outcome (y hat) values at each lambda
}
}
\description{
Internal function for cv_plmm which calls plmm on a fold subset of the original data.
}
\keyword{internal}
