% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{as.pdf.default}
\alias{as.pdf.default}
\title{Convert to PDF by Default}
\usage{
\method{as.pdf}{default}(x, width = getOption("plotscale_pdf_width", 3),
  height = getOption("plotscale_pdf_height", 3), devsize = if (scaled)
  "devsize" else "unscaled", scaled = getOption("plotscale_scaled", TRUE),
  onefile = TRUE, file = if (onefile) "Rplots.pdf" else "Rplot\%03d.pdf",
  ...)
}
\arguments{
\item{x}{object}

\item{width}{desired plot width}

\item{height}{desired plot height}

\item{devsize}{a function of x, width, height, and \dots that calculates device size}

\item{scaled}{whether to rescale width and height by plot size}

\item{onefile}{logical: passed to \code{\link[grDevices]{pdf}}. If true (the default) allow multiple figures in one file. If false, generate a file with name containing the page number for each page. Defaults to TRUE, and forced to true if file is a pipe.}

\item{file}{file name passed to \code{\link[grDevices]{pdf}}}

\item{...}{other arguments to \code{\link[grDevices]{pdf}} and fun}
}
\value{
(invisible) the file argument
}
\description{
Converts object to PDF.  By default, device is scaled by plot size. Device is automatically closed and file argument is returned.
}
\examples{
options(example.ask = FALSE)
options(device.ask.default = FALSE)
library(lattice)
as.pdf(xyplot(2~3),file = tempfile())
}
\seealso{
Other as.pdf: \code{\link{as.pdf}}

Other devices: \code{\link{as.pdf}},
  \code{\link{as.png.default}}, \code{\link{as.png}}
}
