% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digital-ocean.R
\name{do_provision}
\alias{do_provision}
\alias{do_install_plumber}
\alias{do_ip}
\title{Provision a DigitalOcean plumber server}
\usage{
do_provision(droplet, unstable = FALSE, example = TRUE, ...)

do_install_plumber(droplet, unstable, ...)

do_ip(droplet, path)
}
\arguments{
\item{droplet}{The DigitalOcean droplet that you want to provision
(see \code{\link[analogsea:droplet]{analogsea::droplet()}}).}

\item{unstable}{If \code{FALSE}, will install plumber from CRAN. If \code{TRUE}, will
install the unstable version of plumber from GitHub.}

\item{example}{If \code{TRUE}, will deploy an example API named \code{hello}
to the server on port 8000.}

\item{...}{Arguments passed into the \code{\link[analogsea:droplet_create]{analogsea::droplet_create()}} function.}

\item{path}{path to attach to the IP address before browsing.  Should likely
start with a \code{/} or \code{:} (as in \verb{:8080}), otherwise \code{/} will be added.}
}
\value{
The DigitalOcean droplet

The URL to be browsed
}
\description{
Create (if required), install the necessary prerequisites, and
deploy a sample plumber application on a DigitalOcean virtual machine.
You may sign up for a Digital Ocean account
\href{https://www.digitalocean.com/?refcode=add0b50f54c4&utm_campaign=Referral_Invite&utm_medium=Referral_Program&utm_source=CopyPaste}{here}.
You should configure an account ssh key with \code{\link[analogsea:key-crud]{analogsea::key_create()}} prior to using this method.
This command is idempotent, so feel free to run it on a single server multiple times.
}
\details{
Provisions a Ubuntu 20.04-x64 droplet with the following customizations:
\itemize{
\item A recent version of R installed
\item plumber installed globally in the system library
\item An example plumber API deployed at \verb{/var/plumber}
\item A systemd definition for the above plumber API which will ensure that the plumber
API is started on machine boot and respawned if the R process ever crashes. On the
server you can use commands like \verb{systemctl restart plumber} to manage your API, or
\verb{journalctl -u plumber} to see the logs associated with your plumber process.
\item The `nginx`` web server installed to route web traffic from port 80 (HTTP) to your plumber
process.
\item \code{ufw} installed as a firewall to restrict access on the server. By default it only
allows incoming traffic on port 22 (SSH) and port 80 (HTTP).
\item A 4GB swap file is created to ensure that machines with little RAM (the default) are
able to get through the necessary R package compilations.
}
}
\note{
Please see \url{https://github.com/sckott/analogsea/issues/205} in case
of an error by default \code{do_provision} and an error of
\code{"Error: Size is not available in this region."}.
}
\examples{
\dontrun{
  auth = try(analogsea::do_oauth())
  if (!inherits(auth, "try-error") &&
      inherits(auth, "request")) {
    analogsea::droplets()
    droplet = do_provision(region = "sfo3", example = FALSE)
    analogsea::droplets()
    analogsea::install_r_package(droplet, c("readr", "remotes"))
    do_deploy_api(droplet, "hello",
                  system.file("plumber", "10-welcome", package = "plumber"),
                  port=8000, forward=TRUE)
    if (interactive()) {
        utils::browseURL(do_ip(droplet, "/hello"))
    }
    analogsea::droplet_delete(droplet)
  }
}
}
