% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scales.R
\name{scale_x_log10_pl}
\alias{scale_x_log10_pl}
\title{A variant of \code{scale_x_log10()} to show axis minor breaks and
better axis labels}
\usage{
scale_x_log10_pl(
  name = waiver(),
  breaks = NULL,
  minor_breaks = NULL,
  n.breaks = NULL,
  labels = NULL,
  limits = NULL,
  expand = ggplot2::expansion(),
  oob = scales::oob_keep,
  na.value = NA_real_,
  trans = scales::log10_trans(),
  guide = ggh4x::guide_axis_minor(),
  position = "bottom",
  sec.axis = waiver(),
  show_minor_breaks = TRUE
)
}
\arguments{
\item{name}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}

\item{breaks}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks computed by the
\link[scales:trans_new]{transformation object}
\item A numeric vector of positions
\item A function that takes the limits as input and returns breaks
as output (e.g., a function returned by \code{\link[scales:breaks_extended]{scales::extended_breaks()}}).
Also accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{minor_breaks}{One of:
\itemize{
\item \code{NULL} for no minor breaks
\item \code{waiver()} for the default breaks (one minor break between
each major break)
\item A numeric vector of positions
\item A function that given the limits returns a vector of minor breaks. Also
accepts rlang \link[rlang:as_function]{lambda} function notation.
}}

\item{n.breaks}{An integer guiding the number of major breaks. The algorithm
may choose a slightly different number to ensure nice break labels. Will
only have an effect if \code{breaks = waiver()}. Use \code{NULL} to use the default
number of breaks given by the transformation.}

\item{labels}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}

\item{limits}{One of:
\itemize{
\item \code{NULL} to use the default scale range
\item A numeric vector of length two providing limits of the scale.
Use \code{NA} to refer to the existing minimum or maximum
\item A function that accepts the existing (automatic) limits and returns
new limits. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
Note that setting limits on positional scales will \strong{remove} data outside of the limits.
If the purpose is to zoom, use the limit argument in the coordinate system
(see \code{\link[ggplot2:coord_cartesian]{coord_cartesian()}}).
}}

\item{expand}{use \code{expansion()} to dismiss the blank between x axis low limit
and y axis}

\item{oob}{use \code{scales::oob_keep} instead of \code{scales::oob_censor}, which
will always consider the data points out of the limits}

\item{na.value}{Missing values will be replaced with this value.}

\item{trans}{For continuous scales, the name of a transformation object
or the object itself. Built-in transformations include "asn", "atanh",
"boxcox", "date", "exp", "hms", "identity", "log", "log10", "log1p", "log2",
"logit", "modulus", "probability", "probit", "pseudo_log", "reciprocal",
"reverse", "sqrt" and "time".

A transformation object bundles together a transform, its inverse,
and methods for generating breaks and labels. Transformation objects
are defined in the scales package, and are called \verb{<name>_trans} (e.g.,
\code{\link[scales:boxcox_trans]{scales::boxcox_trans()}}). You can create your own
transformation with \code{\link[scales:trans_new]{scales::trans_new()}}.}

\item{guide}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{sec.axis}{\code{\link[ggplot2:sec_axis]{sec_axis()}} is used to specify a secondary axis.}

\item{show_minor_breaks}{show minor breaks or not}
}
\value{
scale object
}
\description{
A variant of \code{scale_x_log10()} to show axis minor breaks and
better axis labels
}
