% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_cal.R
\name{logistic_cal}
\alias{logistic_cal}
\title{Run logistic calibration}
\usage{
logistic_cal(y, p)
}
\arguments{
\item{y}{binary outcome}

\item{p}{predicted probabilities (these will be logit transformed)}
}
\value{
an object of class \code{logistic_cal} containing \code{glm} results for calculating calibration intercept, calibration slope, and LRTs.
}
\description{
Fit the models required to assess calibration in the large (calibration intercept), calibration slope, and overall
'weak' calibration (see, e.g., Van Calster et al. 2019). Fits the models required to do the
three likelihood ratio tests described by Miller et al. (1993) (see \code{summary.logistic_cal}).
}
\examples{
library(pmcalibration)
# simulate some data
n <- 500
dat <- sim_dat(N = n, a1 = .5, a3 = .2)

# predictions
p <- with(dat, invlogit(.5 + x1 + x2 + x1*x2*.1))

logistic_cal(y = dat$y, p = p)
}
\references{
Van Calster, B., McLernon, D. J., Van Smeden, M., Wynants, L., & Steyerberg, E. W. (2019). Calibration: the Achilles heel of predictive analytics. BMC medicine, 17(1), 1-7.

Miller, M. E., Langefeld, C. D., Tierney, W. M., Hui, S. L., & McDonald, C. J. (1993). Validation of probabilistic predictions. Medical Decision Making, 13(1), 49-57.
}
