% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ind_rhs_data_funs.R
\name{ind_rhs_plot_nlmixr}
\alias{ind_rhs_plot_nlmixr}
\title{Generate individual Right-hand side data plot (nlmixr2)}
\usage{
ind_rhs_plot_nlmixr(
  rhs,
  x_var,
  inputs,
  group,
  est_parms = NULL,
  fit_obj = NULL,
  time_nn = NULL,
  act = NULL,
  beta = 20
)
}
\arguments{
\item{rhs}{(string) String of right-hand side}

\item{x_var}{(string) Name of the variable in inputs against which the right-hand data should be plotted.}

\item{inputs}{(dataframe) Dataframe of inputs, with corresponding columns (including matching column names 
for each variable in \emph{rhs}.}

\item{group}{(string) Name of column in \emph{inputs} dataframe defining groups/individuals.}

\item{est_parms}{(named vector; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_nlmixr} function. For optionality, see \strong{Details}.}

\item{fit_obj}{(nlmixr fit object; semi-optional) The fit-object from nlmixr2(...), fitted with IIV. For optionality, see \strong{Details}.}

\item{time_nn}{(boolean vector) Vector for each NN in \emph{rhs} defining whether the neural network is a time-dependent neural network or not. Default value for all NN is FALSE.}

\item{act}{(character vector) Vector for each NN in \emph{rhs} defining the activation function used in the NN. Default value for all NN is "ReLU".}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if any \emph{act} is softplus; Default to 20.}
}
\value{
ggplot of right-hand side for all individuals.
}
\description{
This functions allows to generate a right-hand side plot with multiple subjects, i.e., combined derivative data of multiple NNs and base-R operations.
}
\details{
Either \emph{est_parms} or \emph{fit_obj} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
\dontrun{
ind_fit <- nlmxir2(node_model_ind,data=data,est="saem")
rhs_plot <- ind_rhs_plot_mlx(rhs="NNc + NNct",
                             x_var = "NNc",
                             group = "id",
                             inputs = input_data,
                             fit_obj = ind_fit)
}
}
\author{
Dominic Bräm
}
