% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxpartab.R
\name{fpval}
\alias{fpval}
\title{Format p-values}
\usage{
fpval(
  pval,
  digits = 3,
  eps = 0.001,
  alpha = 0.05,
  star.symbol = "*",
  html = FALSE,
  unicode.le = FALSE
)
}
\arguments{
\item{pval}{A numeric vector of p-values.}

\item{digits}{The number of significant digits to retain.}

\item{eps}{A numeric value. Under this threshold, rather than showing the
p-value itself, show "< 1e-X" where X is the largest integer satisfying
this relationship.}

\item{alpha}{The significance level.}

\item{star.symbol}{A character to display next to those p-values that are
statistically significant (i.e., less then \code{alpha}).}

\item{html}{A logical flag indicating whether to return HTML code or plain
text.}

\item{unicode.le}{A logical flag indicating whether to use unicode
symbol \href{https://www.compart.com/en/unicode/U+2264}{U+2264}
for "less-than-or-equal-to" (only applies when \code{html} is \code{FALSE}).}
}
\value{
A character vector of the same length as \code{pval}.
}
\description{
Format p-values
}
\examples{
x <- c(1, 0.5, 0.05, 0.049, 0.01, 0.001, 0.0001, 0.00001)
fpval(x, html=FALSE, unicode.le=FALSE)
}
\seealso{
\link[base:format.pval]{base::format.pval}
}
