% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmxpartab.R
\name{pmxparframe}
\alias{pmxparframe}
\title{Create a \code{data.frame} of from outputs and metadata}
\usage{
pmxparframe(outputs, meta = get_metadata(outputs))
}
\arguments{
\item{outputs}{A \code{list} of outputs from fitting the model (see Details).}

\item{meta}{A \code{list} of metadata (see Details).}
}
\value{
A \code{data.frame} with a row for each parameter, and the following columns:
\itemize{
\item \code{name}:      name of the parameter (\code{character})
\item \code{fixed}:     fixed or estimated? (\code{logical})
\item \code{est}:       estimated value (\code{numeric})
\item \code{se}:        standard error (\code{numeric})
\item \code{rse}:       percent relative standard error (\code{numeric})
\item \code{lci95}:     lower bound of 95\% confidence interval (\code{numeric})
\item \code{uci95}:     upper bound of 95\% confidence interval (\code{numeric})
\item \code{pval}:      p-value for test of null hypothesis that value is zero (\code{numeric})
\item \code{shrinkage}: percent shrinkage if applicable (\code{numeric})
}

Other attributes from \code{meta} will also be preserved as columns. The order of
the rows is determined by the order of the parameters in \code{meta} (the order
in \code{outputs} is irrelevant).
}
\description{
This can be viewed as the first step in creating a nice-looking HTML table
of model parameters. It combines the "raw" model outputs with metadata and
produces and \code{data.frame}, conceived as an intermediate between the raw
outputs and formatted table, but may also be useful in its own right. The
decoupling of raw outputs from the final table is viewed as essential for
flexibility.
}
\details{
One of the key features of the approach taken in this package is
that it decouples the "raw" outputs of the model from the presentation of
results. A metadata description of the desired presentation of results is
what links the two.  This allows, for example, parameters to be presented in
a different order, or on a different scale, than they were specified in the
model. Hence, it provides more flexibility and control over the presentation
than other approaches.

\code{outputs} is a named \code{list}, with the following elements:
\itemize{
\item \code{est}:       estimated values (i.e., point estimates)
\item \code{se}:        standard errors
\item \code{fixed}:     designates parameters that were fixed rather than estimated
\item \code{shrinkage}: for random effects, the estimated percent shrinkage
}

\code{est}, \code{se} and \code{fixed} have essentially the same structure. They can be
either flat named lists, or more structured named lists containing the following elements:
\itemize{
\item \code{th}     : named list (or vector) of fixed effects
\item \code{om}     : named list (or vector) of individual-level random effects
expressed as standard deviations
\item \code{om_cov} : individual-level random effects expressed as a
variance-covariance matrix
\item \code{om_cor} : individual-level random effects expressed as a matrix of
correlations (off-diagonal elements) and standard deviations (diagonal
elements)
\item \code{sg}     : named list (or vector) of observation-level random effects
expressed as standard deviations
}

\code{meta} is a \code{list}. Each element of \code{meta} is a named (sub)list
representing a parameter.  Each parameter is described by a series of
attributes (not R \code{attributes}, but named list items). Of these, the only
one that is required is \code{name}, which must match the name of the parameter
used in \code{outputs} as it is used to make that association. The optional attributes include:
\itemize{
\item \code{label}:     A descriptive label.
\item \code{units}:     Units, if applicable.
\item \code{type}:      Parameters can be grouped into sections by type. The standard types are:
\itemize{
\item \code{Structural}:      Structural model parameters
\item \code{CovariateEffect}: Parameters that relate covariates to structural parameters
\item \code{IIV}:             Inter-individual (i.e., between-subject) variability
\item \code{IOV}:             Inter-occasion variability
\item \code{RUV}:             Residual unexplained variability
}
\item \code{trans}:     Parameters can be presented on a (back)transformed scale (e.g.,
antilog). Importantly, transformation are also applied to
standard errors (by "propagation of errors", also known as
the delta method) to preserve (asymptotic) correctness, and
to the endpoints of confidence intervals (note: this
typically leads to non-symmetric intervals). Only a small set
of transformations are currently recognized and supported,
which include:
\itemize{
\item \code{identity}:  no transformation
\item \verb{\%},         percent-scale
\item \code{exp}:       antilog
\item \code{ilogit}:    inverse-logit
\item \verb{CV\%}:       intended specifically for IIV parameters, where the
associated structural parameter is log-normally
distributed, transforms the standard deviation \eqn{\omega}
to percent coefficient of variation by the formula
\eqn{100\times\sqrt{\exp(\omega^2)-1}}
\item \verb{SD (CV\%)}:  similar to the above, but the parameter remains on its original
scale (i.e., standard deviation) with the percent coefficient
of variation displayed in parentheses next to it (does not
affect standard errors or confidence intervals).
}
}
}
\examples{
outputs <- list(
  est = list(
    th = list(CL = 0.482334, VC = 0.0592686),
    om = list(nCL = 0.315414, nVC = 0.536025),
    sg = list(ERRP = 0.0508497)),
  se = list(
    th = list(CL = 0.0138646, VC = 0.00555121),
    om = list(nCL = 0.0188891, nVC = 0.0900352),
    sg = list(ERRP = 0.00182851)),
  fixed = list(
    th = list(CL = FALSE, VC = FALSE),
    om = list(nCL = FALSE, nVC = FALSE),
    sg = list(ERRP = FALSE)),
  shrinkage = list(nCL = 9.54556, nVC = 47.8771))

meta <- list(
  parameters = list(
    list(name="CL", label="Clearance", units="L/h", type="Structural"),
    list(name="VC", label="Volume", units="L", type="Structural", trans="exp"),
    list(name="nCL", label="On Clearance", type="IIV", trans="SD (CV\%)"),
    list(name="nVC", label="On Volume", type="IIV"),
    list(name="ERRP", label="Proportional Error", units="\%", type="RUV", trans="\%")))

pmxparframe(outputs, meta)
}
\seealso{
\link{pmxpartab}
}
