% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointr.r
\name{ptr}
\alias{ptr}
\alias{\%=\%}
\alias{rm.ptr}
\alias{where.ptr}
\title{Working with pointers}
\usage{
ptr(symbol1, symbol2)

symbol1 \%=\% symbol2

rm.ptr(symbol1, keep = FALSE)

where.ptr(symbol1)
}
\arguments{
\item{symbol1}{The name of the pointer, as a one-element character vector.}

\item{symbol2}{The object/selection the pointer will point to, as a
one-element character vector.}

\item{keep}{A logical value relevant when removing a pointer with
\code{rm.ptr}. If \code{TRUE}, the pointer variable will be kept and filled
with a copy of the object the pointers points to; if \code{FALSE}, the
pointer variable \code{symbol1} will be removed completely. Default is
\code{FALSE}.}
}
\value{
\code{ptr()}, \code{\%=\%} and \code{rm.ptr()} have no return value.
  \code{ptr()} and \code{\%=\%} create the pointer variable (argument
  \code{symbol1}) in the environment from which it is called.
  \code{where.ptr} returns the object/selection a pointer points to as a
  character vector.
}
\description{
Create, remove and analyze pointers in R. Pointers can point to
  any R object, including selections/subsets.
}
\details{
The \code{ptr()} function and the \code{\%=\%} operator will create
  a pointer to an R object, like a vector, list, dataframe or even a
  subset/selection from a dataframe. \code{where.ptr()} shows where a pointer
  actually points to. Existing pointers can be removed usig the
  \code{rm.ptr()} function. Pointers created with \pkg{pointr} use active
  bindings that call a hidden access function everytime the pointer is
  accessed. This hidden access function is named \code{.pointer()} (where
  \code{pointer} is the name of the pointer variable) and is created in the
  environment from which \code{ptr()} is called. It is not necessary to call
  this hidden access function as a pointer user. The hidden access function
  is removed when \code{rm.ptr()} is called.
}
\section{Contributions}{
 Thanks to Chad Hammerquist for contributing the
  \code{pointr} operator \code{\%=\%}.
}

\examples{

library(pointr)

# Pointer to simple variable

myvar <- 3
ptr("mypointer", "myvar")
mypointer

myvar <- 5
mypointer

mypointer <- 7
myvar


# Alternative: Use the pointr operator \%=\%

myvar <- 3
mypointr \%=\% myvar
myvar


# Pointer to subset from dataframe

df <- data.frame(list(var1 = c(1,2,3), var2 = c("a", "b", "c")), stringsAsFactors = FALSE)
df

i <- 2
ptr("sel", "df$var2[i]")

sel <- "hello"
df$var2[i]

df$var2[i] <- "world"
sel

where.ptr("sel")
}
\concept{pointr}
