% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cpos.R
\name{cpos}
\alias{cpos}
\alias{cpos,corpus-method}
\alias{cpos,character-method}
\alias{cpos,slice-method}
\alias{cpos,partition-method}
\alias{cpos,subcorpus-method}
\alias{cpos,matrix-method}
\alias{cpos,hits-method}
\alias{cpos,NULL-method}
\title{Get corpus positions for a query or queries.}
\usage{
cpos(.Object, ...)

\S4method{cpos}{corpus}(
  .Object,
  query,
  p_attribute = getOption("polmineR.p_attribute"),
  cqp = is.cqp,
  regex = FALSE,
  check = TRUE,
  verbose = TRUE,
  ...
)

\S4method{cpos}{character}(
  .Object,
  query,
  p_attribute = getOption("polmineR.p_attribute"),
  cqp = is.cqp,
  check = TRUE,
  verbose = TRUE,
  ...
)

\S4method{cpos}{slice}(
  .Object,
  query,
  cqp = is.cqp,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  verbose = TRUE,
  ...
)

\S4method{cpos}{partition}(
  .Object,
  query,
  cqp = is.cqp,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  verbose = TRUE,
  ...
)

\S4method{cpos}{subcorpus}(
  .Object,
  query,
  cqp = is.cqp,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  verbose = TRUE,
  ...
)

\S4method{cpos}{matrix}(.Object)

\S4method{cpos}{hits}(.Object)

\S4method{cpos}{`NULL`}(.Object)
}
\arguments{
\item{.Object}{A length-one \code{character} vector indicating a CWB corpus, or a
\code{corpus}, or \code{partition} object.}

\item{...}{Used for reasons of backwards compatibility to
process arguments that have been renamed (e.g. \code{pAttribute}).}

\item{query}{A \code{character} vector providing one or multiple queries (token to
look up, regular expression or CQP query). Token ids (i.e. \code{integer}
values) are also accepted. If \code{query} is neither a regular expression nor a
CQP query, a sanity check removes accidental leading/trailing whitespace,
issuing a respective warning.}

\item{p_attribute}{The p-attribute to search. Needs to be stated only if query
is not a CQP query. Defaults to \code{NULL}.}

\item{cqp}{Either logical (\code{TRUE} if query is a CQP query), or a function to
check whether query is a CQP query or not (defaults to \code{is.cqp} auxiliary
function).}

\item{regex}{Interpret \code{query} as a regular expression.}

\item{check}{A \code{logical} value, whether to check validity of CQP query
using \code{check_cqp_query}.}

\item{verbose}{A \code{logical} value, whether to show messages.}
}
\value{
A \code{matrix} with two columns.  The first column reports the
left/starting corpus positions (cpos) of the hits obtained. The second
column reports the right/ending corpus positions of the respective hit. The
number of rows is the number of hits. If there are no hits, \code{NULL} is
returned.
}
\description{
Get matches for a query in a CQP corpus (subcorpus, partition etc.),
optionally using the CQP syntax of the Corpus Workbench (CWB).
}
\details{
The \code{cpos()}-method returns a two-column \code{matrix} with the ranges (start end
end corpus positions of the matches) matched by a query. CQP syntax can be
used. The encoding of the query is adjusted to conform to the encoding of the
CWB corpus. If there are not matches, \code{NULL} is returned.

Previous polmineR versions defined the \code{cpos()}-method for \code{matrix} and
\code{hits} objects to obtain an integer vector with unfolded individual corpus
positions. This usage is deprecated starting with polmineR v0.8.8
}
\examples{
use(pkg = "RcppCWB", corpus = "REUTERS")

# look up single tokens
cpos("REUTERS", query = "oil")
corpus("REUTERS") \%>\% cpos(query = "oil")

corpus("REUTERS") \%>\%
  subset(grepl("saudi-arabia", places)) \%>\%
  cpos(query = "oil")
  
partition("REUTERS", places = "saudi-arabia", regex = TRUE) \%>\%
  cpos(query = "oil")

# use CQP query syntax
cpos("REUTERS", query = '"Saudi" "Arabia"')
corpus("REUTERS") \%>\% cpos(query = '"Saudi" "Arabia"')
corpus("REUTERS") \%>\%
  subset(grepl("saudi-arabia", places)) \%>\%
  cpos(query = '"Saudi" "Arabia"', cqp = TRUE)
partition("REUTERS", places = "saudi-arabia", regex = TRUE) \%>\%
  cpos(query = '"Saudi" "Arabia"', cqp = TRUE)
}
