% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hits.R
\name{hits}
\alias{hits}
\alias{hits,corpus-method}
\alias{hits,character-method}
\alias{hits,subcorpus-method}
\alias{hits,partition-method}
\alias{hits,partition_bundle-method}
\alias{hits,context-method}
\alias{hits,remote_corpus-method}
\alias{hits,remote_subcorpus-method}
\title{Get hits for query}
\usage{
hits(.Object, ...)

\S4method{hits}{corpus}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  s_attribute,
  p_attribute = "word",
  size = FALSE,
  freq = FALSE,
  decode = TRUE,
  fill = FALSE,
  mc = 1L,
  verbose = TRUE,
  progress = FALSE,
  ...
)

\S4method{hits}{character}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  s_attribute,
  p_attribute = "word",
  size = FALSE,
  freq = FALSE,
  decode = TRUE,
  mc = FALSE,
  verbose = TRUE,
  progress = FALSE,
  ...
)

\S4method{hits}{subcorpus}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  s_attribute,
  p_attribute = "word",
  size = FALSE,
  freq = FALSE,
  fill = FALSE,
  decode = TRUE,
  mc = FALSE,
  progress = FALSE,
  verbose = TRUE,
  ...
)

\S4method{hits}{partition}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  s_attribute,
  p_attribute = "word",
  size = FALSE,
  freq = FALSE,
  fill = FALSE,
  decode = TRUE,
  mc = FALSE,
  progress = FALSE,
  verbose = TRUE
)

\S4method{hits}{partition_bundle}(
  .Object,
  query,
  cqp = FALSE,
  check = TRUE,
  p_attribute = getOption("polmineR.p_attribute"),
  s_attribute,
  size = TRUE,
  freq = FALSE,
  mc = getOption("polmineR.mc"),
  progress = FALSE,
  verbose = TRUE,
  ...
)

\S4method{hits}{context}(.Object, s_attribute = NULL, verbose = TRUE, ...)

\S4method{hits}{remote_corpus}(.Object, ...)

\S4method{hits}{remote_subcorpus}(.Object, ...)
}
\arguments{
\item{.Object}{A length-one \code{character} vector with a corpus ID, a
\code{partition} or \code{partition_bundle} object}

\item{...}{Further arguments (used for backwards compatibility).}

\item{query}{A \code{character} vector (optionally named, see details) with one or
more queries.}

\item{cqp}{Either a \code{logical} value (\code{TRUE} if query is a CQP query), or a
function to check whether \code{query} is a CQP query or not.}

\item{check}{A \code{logical} value, whether to check validity of CQP query using
\code{check_cqp_query}.}

\item{s_attribute}{A \code{character} vector of s-attributes that will be
used to breakdown counts for matches for query/queries.}

\item{p_attribute}{A \code{character} vector stating a p-attribute.}

\item{size}{A \code{logical} value, whether to report the size of subcorpus.}

\item{freq}{A \code{logcial} value, whether to report relative frequencies.}

\item{decode}{A \code{logical} value, whether to decode s-attributes. If \code{FALSE},
the \code{integer} values of strucs are reported in the table with matches.}

\item{fill}{A \code{logical} value, whethet to report counts (optionally
frequencies) for combinations of s-attributes where not matchers occurr.}

\item{mc}{A \code{logical} value, whether to use multicore.}

\item{verbose}{A \code{logical} value, whether to output messages.}

\item{progress}{A \code{logical} value, whether to show progress bar.}
}
\value{
A \code{hits} class object.
}
\description{
Get hits for queries, optionally with s-attribute values.
}
\details{
If the \code{character} vector provided by \code{query} is named, these names will be
reported in the \code{data.table} that is returned rather than the queries.

If \code{freq} is \code{TRUE}, the \code{data.table} returned in the DT-slot will
deliberately include the subsets of the \code{partition}/\code{corpus} with no hits
(query is NA, count is 0).
}
\examples{
use(pkg = "RcppCWB", corpus = "REUTERS")

# get hits for corpus object
y <- corpus("REUTERS") \%>\% hits(query = "oil")
y <- corpus("REUTERS") \%>\% hits(query = c("oil", "barrel"))
y <- corpus("REUTERS") \%>\% hits(query = "oil", s_attribute = "places", freq = TRUE)

# specify corpus by corpus ID
y <- hits("REUTERS", query = "oil")
y <- hits("REUTERS", query = "oil", s_attribute = "places", freq = TRUE)

# get hits for partition
p <- partition("REUTERS", places = "saudi-arabia", regex = TRUE)
y <- hits(p, query = "oil", s_attribute = "id")

# get hits for subcorpus
y <- corpus("REUTERS") \%>\%
  subset(grep("saudi-arabia", places)) \%>\%
  hits(query = "oil")
}
\seealso{
See the documentation of the \code{hits} class
(\code{\link{hits-class}}) for details.
}
