% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S4classes.R, R/partition_bundle.R, R/enrich.R,
%   R/utils.R
\docType{class}
\name{partition_bundle-class}
\alias{partition_bundle-class}
\alias{[,partition_bundle-method}
\alias{[[,partition_bundle-method}
\alias{as.matrix,partition_bundle-method}
\alias{merge,partition_bundle-method}
\alias{+,partition_bundle-method}
\alias{names,partition_bundle-method}
\alias{summary,partition_bundle-method}
\alias{+,partition_bundle,ANY-method}
\alias{[,partition_bundle,ANY,ANY,ANY-method}
\alias{+,partition_bundle,partition-method}
\alias{+,partition_bundle,partition_bundle-method}
\alias{as.partition_bundle,list-method}
\alias{barplot,partition_bundle-method}
\alias{show,partition_bundle-method}
\alias{partition_bundle,environment-method}
\alias{enrich,partition_bundle-method}
\alias{enrich,subcorpus_bundle-method}
\alias{flatten}
\title{Bundle of partitions (partition_bundle class).}
\usage{
\S4method{show}{partition_bundle}(object)

\S4method{summary}{partition_bundle}(object, progress = FALSE)

\S4method{merge}{partition_bundle}(x, name = "", verbose = FALSE)

\S4method{barplot}{partition_bundle}(height, ...)

\S4method{as.partition_bundle}{list}(.Object, ...)

\S4method{partition_bundle}{environment}(.Object)

\S4method{enrich}{partition_bundle}(.Object, p_attribute, decode = TRUE, verbose = FALSE)

\S4method{enrich}{subcorpus_bundle}(.Object, p_attribute, decode = TRUE, verbose = FALSE)

flatten(object)
}
\arguments{
\item{object}{A \code{partition_bundle} object.}

\item{progress}{A \code{logical} value, whether to show progress bar.}

\item{x}{A \code{partition_bundle} object.}

\item{name}{the name for the new partition}

\item{verbose}{A \code{logical} value, whether to show progress messages.}

\item{height}{height}

\item{...}{further parameters}

\item{.Object}{A \code{partition_bundle} object.}

\item{p_attribute}{A \code{character} vector with p-attribute(s) for counting.}

\item{decode}{A \code{logical} value, whether to turn token ids into decoded
strings.}
}
\value{
An object of the class 'partition. See partition for the
details on the class.

a \code{partition_bundle} object
}
\description{
Class and methods to manage bundles of partitions.
}
\details{
The \code{merge}-method aggregates several partitions into one partition. The
prerequisite for this function to work properly is that there are no
overlaps of the different partitions that are to be summarized.
Encodings and the root node need to be identical, too.

The \code{enrich()} method will fill the slot \code{stat} of the \code{partition}
objects within the bundle with a count for the designated p-attributes. If
\code{.Object} is a \code{subcorpus_bundle}, the output class will be a
\code{partition_bundle}.
}
\section{Slots}{

\describe{
\item{\code{objects}}{Object of class \code{list} the partitions making up the bundle}

\item{\code{corpus}}{Object of class \code{character} the CWB corpus the partition is based on}

\item{\code{s_attributes_fixed}}{Object of class \code{list} fixed s-attributes}

\item{\code{encoding}}{Object of class \code{character} encoding of the corpus}

\item{\code{explanation}}{Object of class \code{character} an explanation of the partition}

\item{\code{xml}}{Object of class \code{character} whether the xml is flat or nested}

\item{\code{call}}{Object of class \code{character} the call that generated the \code{partition_bundle}}
}}

\examples{

# merge partition_bundle into one partition
gparl <- corpus("GERMAPARLMINI") \%>\%
  split(s_attribute = "date") \%>\% 
  merge()
use(pkg = "RcppCWB", corpus = "REUTERS")

pb <- partition_bundle("REUTERS", s_attribute = "id")
barplot(pb, las = 2)

sc <- corpus("GERMAPARLMINI") \%>\%
  subset(date == "2009-11-10") \%>\%
  split(s_attribute = "speaker") \%>\%
  barplot(las = 2)
}
\author{
Andreas Blaette
}
