% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcri_translate_text.R
\name{qcri_translate_text}
\alias{qcri_translate_text}
\title{QCRI Translate Text}
\usage{
qcri_translate_text(text, langpair, domain, api_key = qcri_api_key())
}
\arguments{
\item{text}{The text to be translated. This must be URL encoded.}

\item{langpair}{The source-target language pair, where source is language of the provided text and target is the language into which the text has to be translated.}

\item{domain}{The domain over which the translation is tuned.}

\item{api_key}{The API key associated with the user account being used. If not provided, the function will attempt to retrieve it from the QCRI_API_KEY environment variable.}
}
\value{
Translated text.
}
\description{
This function translates a text from the source language to the target language using the QCRI Multiterm API.
}
\examples{
\dontrun{
qcri_translate_text(text = "Hello, world!",
langpair = "en-ar",
domain = "general",
api_key = "YourApiKey")
qcri_translate_text(text = "Hello, world!",
langpair = "en-ar",
domain = "general")
}
}
