% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_Model.R
\name{GLM_Model}
\alias{GLM_Model}
\title{Generalized Linear Model}
\usage{
GLM_Model(Data, xvar, yvar)
}
\arguments{
\item{Data}{The name of the Dataset.}

\item{xvar}{X variables.}

\item{yvar}{Y variable.}
}
\value{
The output from  \code{\link{GLM_Model}}.
}
\description{
Generalized Linear Model
}
\details{
Let \bold{y} be a vector of response variable of accessing credit for each applicant
\eqn{n}{n}, such that \eqn{y_{i}=1}{y_{i} =  1}  if the applicant-\eqn{i}{i}
has access to credit, and zero otherwise. Furthermore, let
let \eqn{\bold{x} = x_{ij}},  where
\eqn{i=1,\ldots,n}{i=1,...,n} and \eqn{j=1,\ldots,p}{j=1,...,p} characteristics of the applicants.
The log-odds can be define as:

 \deqn{log(\frac{\pi_{i}}{1-\pi_{i}}) = \beta_{0}+\bold{x}_{\bold{i}}\beta = \beta_{0}+\sum_{i=1}^{p}\beta_{i}\bold{x}_{i}}

 \eqn{\beta_{0}}{\beta_{0}} is the intercept, \eqn{\beta = (\beta_{1},\ldots, \beta_{p})} is
 a \eqn{p} \eqn{x} \eqn{1} vector of coefficients and
	     \eqn{\bold{x_{i}}}{x_{i}} is the \eqn{i_{th}}{i_{th}} row of  \bold{x}.
}
\examples{
yvar <- c("multi.level")
sample_data <- sample_data[c(1:750),]
xvar <- c("sex", "married", "age", "havejob", "educ", "political.afl",
"rural", "region", "fin.intermdiaries", "fin.knowldge", "income")
BchMk.GLM <- GLM_Model(sample_data, c(xvar, "networth"), yvar )
BchMk.GLM$finalModel
BchMk.GLM$Roc$auc
}
