% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initial-class.R
\name{initial}
\alias{initial}
\title{Initial values constructor for pompp modeling}
\usage{
initial(
  beta = numeric(),
  delta = numeric(),
  lambdaStar = numeric(),
  marksMean = numeric(),
  marksPrecision = numeric(),
  random = FALSE
)
}
\arguments{
\item{beta}{Either a vector or a single integer. The vector is used if the
initial values are provided and the integer is used as the vector size to
be randomly generated.}

\item{delta}{Either a vector or a single integer. The vector is used if the
initial values are provided and the integer is used as the vector size to
be randomly generated.}

\item{lambdaStar}{A positive number.}

\item{marksMean}{Any real number. If random, defines the mean of the random
value.}

\item{marksPrecision}{A positive number. If random, defines the mean of the
random value.}

\item{random}{A logical value. If \code{TRUE}, then the initial values are
generated from standard normal distribution for \code{beta} and \code{delta}
and from a \code{Beta(lambdaStar, 1)} for \code{lambdaStar}. The latter is
generated as a low value due to potential explosive values resulting from
background area scaling.}
}
\value{
A \code{pompp_initial} object. It can be used in the
\code{fit_pompp} function by itself, but must be in a list if multiple
initial values are supplied. Initial values can be combined by adding them
(with the use of \code{+}).
}
\description{
Helper function to create a valid set of initial values to be used with the
fit_pompp function.
}
\examples{
# Let us create initial values for a model with, say, 3 intensity covariates
# and 4 observability covariates. We add an initial values for both these
# cases due to the intercepts.

# This first one is
in1 <- initial(rep(0, 4), c(0, 2, -1, -2, 3), 100, 0, 1)

# Then we initalize some randomly.
in2 <- initial(4, 5, 100, 0, 1, random = TRUE)

# We can even multiply the random one to generate more. Let us join them all
# to include in a model.
initial_values <- in1 + in2 * 3
# 4 chains are initialized.
}
\seealso{
\code{\link{pompp_initial-class}}.
}
